package com.ejianc.business.steelstructure.promaterial.contract.api;

import com.ejianc.business.steelstructure.promaterial.contract.hystrix.IPromaterialContractHystrix;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(
        name = "ejc-promaterial-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-promaterial-web",
        fallback = IPromaterialContractHystrix.class
)
public interface IPromaterialContractApi {

    /**
     * 根据定标参照id查询对应的合同
     *
     * @param targetResultIdList 定标结果参照id
     * @return 修改结果
     */
    @RequestMapping(
            value = {"/api/contract/queryContractByTargetResultId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam("targetResultIdList") List<String> targetResultIdList);
}
