package com.ejianc.business.steelstructure.promaterial.contract.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;


/**
 * 合同冻结表
 * 
 * @author generator
 * 
 */
@ApiModel("合同冻结表")
public class PromaterialContractFreezeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("项目Id")
    private Long projectId;
    @ApiModelProperty("项目名称（带入）")
    private String projectName;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同编码")
    private String contractCode;
    @ApiModelProperty("项目部id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("项目部所属组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部所属组织编码")
    private String parentOrgCode;
    @ApiModelProperty("供应商id(乙方)")
    private Long supplierId;
    @ApiModelProperty("供应商名称（乙方）")
    private String supplierName;
    @ApiModelProperty("申请人 即经办人")
    private Long employeeId;
    @ApiModelProperty("申请人信息 即经办人")
    private String employeeName;
    @ApiModelProperty("经办单位id")
    private Long departmentId;
    @ApiModelProperty("经办单位")
    private String departmentName;
    @ApiModelProperty("经办单位编码")
    private String departmentCode;
    @ApiModelProperty("甲方")
    private String firstPartyName;
    @ApiModelProperty("甲方id")
    private Long firstPartyId;
    @ApiModelProperty("冻结/取消冻结 原因")
    private String freezeCause;
    @ApiModelProperty("合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结")
    private String performanceStatus;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("冻结日期（默认当前时间 可修改）")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date freezeDate;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("单据类型")
    private String billTypeCode;
    @ApiModelProperty("提交日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate;
    @ApiModelProperty("提交人名称")
    private String commitUserName;
    @ApiModelProperty("生效日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate;
    @ApiModelProperty("提交人账号")
    private String commitUserCode;
    

    /**
     * 项目Id
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称（带入）
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称（带入）
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目部id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部所属组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部所属组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部所属组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 供应商id(乙方)
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id(乙方)
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称（乙方）
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称（乙方）
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 申请人 即经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 申请人 即经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 申请人信息 即经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 申请人信息 即经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办单位id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办单位id
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办单位
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办单位
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 经办单位编码
     */
    public String getDepartmentCode() {
        return departmentCode;
    }

    /**
     * 经办单位编码
     */
    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    /**
     * 甲方
     */
    public String getFirstPartyName() {
        return firstPartyName;
    }

    /**
     * 甲方
     */
    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    /**
     * 甲方id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    /**
     * 甲方id
     */
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    /**
     * 冻结/取消冻结 原因
     */
    public String getFreezeCause() {
        return freezeCause;
    }

    /**
     * 冻结/取消冻结 原因
     */
    public void setFreezeCause(String freezeCause) {
        this.freezeCause = freezeCause;
    }
    /**
     * 合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结
     */
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    /**
     * 合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结
     */
    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 冻结日期（默认当前时间 可修改）
     */
    public Date getFreezeDate() {
        return freezeDate;
    }

    /**
     * 冻结日期（默认当前时间 可修改）
     */
    public void setFreezeDate(Date freezeDate) {
        this.freezeDate = freezeDate;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据类型
     */
    public String getBillTypeCode() {
        return billTypeCode;
    }

    /**
     * 单据类型
     */
    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }
    /**
     * 提交日期
     */
    public Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 生效日期
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效日期
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    /**
     * 提交人账号
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人账号
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    
}
