package com.ejianc.business.steelstructure.promaterial.pricelib.vo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *
 */
public enum HistoryTypeEnum {

    合同历史价(1,"合同历史价"),
    结算历史价(2,"结算历史价"),
    验收历史价(3,"验收历史价");

    private final Integer code;
    private final String description;

    private static Map<Integer, com.ejianc.business.steelstructure.promaterial.pricelib.vo.HistoryTypeEnum> enumMap = new HashMap<>();

    public Integer getCode() {
        return code;
    }
    public String getDescription() {
        return description;
    }

    HistoryTypeEnum(Integer code,String description) {
        this.code = code;
        this.description = description;
    }


    static {
        enumMap = EnumSet.allOf(com.ejianc.business.steelstructure.promaterial.pricelib.vo.HistoryTypeEnum.class).stream().collect(Collectors.toMap(com.ejianc.business.steelstructure.promaterial.pricelib.vo.HistoryTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static com.ejianc.business.steelstructure.promaterial.pricelib.vo.HistoryTypeEnum getEnumByStateCode(Integer code) {
        return enumMap.get(code);
    }
}

