package com.ejianc.business.steelstructure.finance.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 付款申请详情实体
 *
 * @author generator
 *
 */
public class PaymentApplyDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long createUserId; // 创建者账号
    private Long payId; // 付款申请id
    private Long sourceId; // 结算id 来源
    private String sourceBillCode; // 结算单据号
    private String sourceType; // 来源类型
    private Long contractId; // 合同id
    private Long projectOrgId; // 项目部所属组织id
    private Long supplierId; // 乙方id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    private BigDecimal currentSettleMny; // 本期结算金额
    private BigDecimal currentApplyMny; // 本期申请金额
    private BigDecimal alreadyApplyMny; // 已申请金额
    private BigDecimal residueApplyMny; // 剩余可申请金额
    private BigDecimal advancePaymentDeduction; // 预付款扣减分摊
    private BigDecimal actualPaymentMny; // 实际付款金额
    private BigDecimal actualApplyMny; // 实际申请占用金额 默认等于申请金额 关闭后默认等于实际付款
    private String memo; // 备注 非必填，0-500字
    private String settleLinkUrl;
    private String sourceTypeName;//结算类型名称
    private BigDecimal totalAppMny;//累计申请金额(含本期)
    private BigDecimal totalSettlePaymentTaxMny;//累计结算支付金额（含税）
    private String sourceTypeNameStr;//结算类型

    public String getSourceTypeNameStr() {
        return sourceTypeNameStr;
    }

    public void setSourceTypeNameStr(String sourceTypeNameStr) {
        this.sourceTypeNameStr = sourceTypeNameStr;
    }

    public BigDecimal getTotalSettlePaymentTaxMny() {
        return totalSettlePaymentTaxMny;
    }

    public void setTotalSettlePaymentTaxMny(BigDecimal totalSettlePaymentTaxMny) {
        this.totalSettlePaymentTaxMny = totalSettlePaymentTaxMny;
    }

    public BigDecimal getTotalAppMny() {
        return totalAppMny;
    }

    public void setTotalAppMny(BigDecimal totalAppMny) {
        this.totalAppMny = totalAppMny;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getSettleLinkUrl() {
        return settleLinkUrl;
    }

    public void setSettleLinkUrl(String settleLinkUrl) {
        this.settleLinkUrl = settleLinkUrl;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public Long getPayId() {
        return payId;
    }

    public void setPayId(Long payId) {
        this.payId = payId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public BigDecimal getCurrentSettleMny() {
        return currentSettleMny;
    }

    public void setCurrentSettleMny(BigDecimal currentSettleMny) {
        this.currentSettleMny = currentSettleMny;
    }
    public BigDecimal getCurrentApplyMny() {
        return currentApplyMny;
    }

    public void setCurrentApplyMny(BigDecimal currentApplyMny) {
        this.currentApplyMny = currentApplyMny;
    }
    public BigDecimal getAlreadyApplyMny() {
        return alreadyApplyMny;
    }

    public void setAlreadyApplyMny(BigDecimal alreadyApplyMny) {
        this.alreadyApplyMny = alreadyApplyMny;
    }
    public BigDecimal getResidueApplyMny() {
        return residueApplyMny;
    }

    public void setResidueApplyMny(BigDecimal residueApplyMny) {
        this.residueApplyMny = residueApplyMny;
    }
    public BigDecimal getAdvancePaymentDeduction() {
        return advancePaymentDeduction;
    }

    public void setAdvancePaymentDeduction(BigDecimal advancePaymentDeduction) {
        this.advancePaymentDeduction = advancePaymentDeduction;
    }
    public BigDecimal getActualPaymentMny() {
        return actualPaymentMny;
    }

    public void setActualPaymentMny(BigDecimal actualPaymentMny) {
        this.actualPaymentMny = actualPaymentMny;
    }
    public BigDecimal getActualApplyMny() {
        return actualApplyMny;
    }

    public void setActualApplyMny(BigDecimal actualApplyMny) {
        this.actualApplyMny = actualApplyMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
