package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.List;


/**
 * 洽商签证索赔
 * 
 * @author generator
 * 
 */
public class ClaimVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String claimTitle; // 洽商签证索赔标题
    private Long negotiateTypeId; // 洽商类型
    private Long visaTypeId; // 签证类型
    private Long claimTypeId; // 索赔类型
    private String typeName; // 洽商签证索赔类型名称
    private java.math.BigDecimal taxRate; // 税率
    private java.math.BigDecimal claimMny; // 洽商签证索赔金额(无税)
    private java.math.BigDecimal claimTaxMny; // 洽商签证索赔金额
    private java.math.BigDecimal claimTax; // 洽商签证索赔金额税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date submitDate; // 提交甲方日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date replyDate; // 甲方批复日期
    private String replyStatus; // 甲方批复状态(0-未批复，1-已批复，2-未通过)
    private java.math.BigDecimal replyMny; // 甲方批复金额(无税)
    private java.math.BigDecimal replyTaxMny; // 甲方批复金额
    private java.math.BigDecimal replyTax; // 甲方批复金额税额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String claimInstruction; // 洽商签证索赔说明
    private String billType; // 单据类型(QS-洽商，QZ-签证，SP-索赔)

    private String replyStatusName; // 甲方批复状态名称
    private String billStateName; //单据状态名称
    private String contractVersion; //施工合同版本
    private String date; // 甲方批复日期字符串
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private String commitDate; // 提交日期
    
    private List<Long> budgetIds = new ArrayList<>();

    private List<Long> claimRecordIds = new ArrayList<>();

    private List<ClaimVO> replayRecordIds = new ArrayList<>();

    private Integer claimDuration; // 索赔工期
    private Integer replyDuration; // 批复工期
    private Long costAdjustId; // 工程造价调整申请单据id
    private String billTypeName; // 单据类型名称

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String billPushFlag;
    @ConvertField(targetField = "sourceId,contractId,id")
    private Long id;

    @ConvertField
    private Integer dr;


    private Integer replayState; // 是否进行甲方批复
    private Integer isReplayBill; // 是否甲方批复单据

    private Long replayBillId; // 甲方批复单据id/主单据id
    private Integer billSourceType; // 变更洽商来源（1：甲方，2：其他）
    private Integer replayBillType; // 甲方批复单据类型（0：批复，1：确认）
    private String claimType; // 二次经营分类

    public String getClaimType() {
        return claimType;
    }

    public void setClaimType(String claimType) {
        this.claimType = claimType;
    }

    public Integer getReplayBillType() {
        return replayBillType;
    }

    public void setReplayBillType(Integer replayBillType) {
        this.replayBillType = replayBillType;
    }

    public List<ClaimVO> getReplayRecordIds() {
        return replayRecordIds;
    }

    public void setReplayRecordIds(List<ClaimVO> replayRecordIds) {
        this.replayRecordIds = replayRecordIds;
    }

    public Integer getBillSourceType() {
        return billSourceType;
    }

    public void setBillSourceType(Integer billSourceType) {
        this.billSourceType = billSourceType;
    }


    public Long getReplayBillId() {
        return replayBillId;
    }

    public void setReplayBillId(Long replayBillId) {
        this.replayBillId = replayBillId;
    }


    public Integer getReplayState() {
        return replayState;
    }

    public void setReplayState(Integer replayState) {
        this.replayState = replayState;
    }

    public Integer getIsReplayBill() {
        return isReplayBill;
    }

    public void setIsReplayBill(Integer isReplayBill) {
        this.isReplayBill = isReplayBill;
    }

    public String getBillTypeName() {
        return billTypeName;
    }

    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    public Long getCostAdjustId() {
        return costAdjustId;
    }

    public void setCostAdjustId(Long costAdjustId) {
        this.costAdjustId = costAdjustId;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }


    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同ID
     */
    @ReferSerialTransfer(referCode = "ref-contract-register")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同ID
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 洽商签证索赔标题
     */
    public String getClaimTitle() {
        return claimTitle;
    }

    /**
     * 洽商签证索赔标题
     */
    public void setClaimTitle(String claimTitle) {
        this.claimTitle = claimTitle;
    }
    /**
     * 洽商类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getNegotiateTypeId() {
        return negotiateTypeId;
    }

    /**
     * 洽商类型
     */
    @ReferDeserialTransfer
    public void setNegotiateTypeId(Long negotiateTypeId) {
        this.negotiateTypeId = negotiateTypeId;
    }
    /**
     * 签证类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getVisaTypeId() {
        return visaTypeId;
    }

    /**
     * 签证类型
     */
    @ReferDeserialTransfer
    public void setVisaTypeId(Long visaTypeId) {
        this.visaTypeId = visaTypeId;
    }
    /**
     * 索赔类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getClaimTypeId() {
        return claimTypeId;
    }

    /**
     * 索赔类型
     */
    @ReferDeserialTransfer
    public void setClaimTypeId(Long claimTypeId) {
        this.claimTypeId = claimTypeId;
    }
    /**
     * 洽商签证索赔类型名称
     */
    public String getTypeName() {
        return typeName;
    }

    /**
     * 洽商签证索赔类型名称
     */
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 洽商签证索赔金额(无税)
     */
    public java.math.BigDecimal getClaimMny() {
        return claimMny;
    }

    /**
     * 洽商签证索赔金额(无税)
     */
    public void setClaimMny(java.math.BigDecimal claimMny) {
        this.claimMny = claimMny;
    }
    /**
     * 洽商签证索赔金额
     */
    public java.math.BigDecimal getClaimTaxMny() {
        return claimTaxMny;
    }

    /**
     * 洽商签证索赔金额
     */
    public void setClaimTaxMny(java.math.BigDecimal claimTaxMny) {
        this.claimTaxMny = claimTaxMny;
    }
    /**
     * 洽商签证索赔金额税额
     */
    public java.math.BigDecimal getClaimTax() {
        return claimTax;
    }

    /**
     * 洽商签证索赔金额税额
     */
    public void setClaimTax(java.math.BigDecimal claimTax) {
        this.claimTax = claimTax;
    }
    /**
     * 提交甲方日期
     */
    public java.util.Date getSubmitDate() {
        return submitDate;
    }

    /**
     * 提交甲方日期
     */
    public void setSubmitDate(java.util.Date submitDate) {
        this.submitDate = submitDate;
    }
    /**
     * 甲方批复日期
     */
    public java.util.Date getReplyDate() {
        return replyDate;
    }

    /**
     * 甲方批复日期
     */
    public void setReplyDate(java.util.Date replyDate) {
        this.replyDate = replyDate;
    }
    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public String getReplyStatus() {
        return replyStatus;
    }

    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public void setReplyStatus(String replyStatus) {
        this.replyStatus = replyStatus;
    }
    /**
     * 甲方批复金额(无税)
     */
    public java.math.BigDecimal getReplyMny() {
        return replyMny;
    }

    /**
     * 甲方批复金额(无税)
     */
    public void setReplyMny(java.math.BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    /**
     * 甲方批复金额
     */
    public java.math.BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    /**
     * 甲方批复金额
     */
    public void setReplyTaxMny(java.math.BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }
    /**
     * 甲方批复金额税额
     */
    public java.math.BigDecimal getReplyTax() {
        return replyTax;
    }

    /**
     * 甲方批复金额税额
     */
    public void setReplyTax(java.math.BigDecimal replyTax) {
        this.replyTax = replyTax;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 洽商签证索赔说明
     */
    public String getClaimInstruction() {
        return claimInstruction;
    }

    /**
     * 洽商签证索赔说明
     */
    public void setClaimInstruction(String claimInstruction) {
        this.claimInstruction = claimInstruction;
    }
    /**
     * 单据类型(QS-洽商，QZ-签证，SP-索赔)
     */
    public String getBillType() {
        return billType;
    }

    /**
     * 单据类型(QS-洽商，QZ-签证，SP-索赔)
     */
    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getReplyStatusName() {
        return replyStatusName;
    }

    public void setReplyStatusName(String replyStatusName) {
        this.replyStatusName = replyStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(String contractVersion) {
        this.contractVersion = contractVersion;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public List<Long> getBudgetIds() {
        return budgetIds;
    }

    public void setBudgetIds(List<Long> budgetIds) {
        this.budgetIds = budgetIds;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(String commitDate) {
        this.commitDate = commitDate;
    }

    public Integer getClaimDuration() {
        return claimDuration;
    }

    public void setClaimDuration(Integer claimDuration) {
        this.claimDuration = claimDuration;
    }

    public Integer getReplyDuration() {
        return replyDuration;
    }

    public void setReplyDuration(Integer replyDuration) {
        this.replyDuration = replyDuration;
    }

    public List<Long> getClaimRecordIds() {
        return claimRecordIds;
    }

    public void setClaimRecordIds(List<Long> claimRecordIds) {
        this.claimRecordIds = claimRecordIds;
    }
}
