package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

public class WinningBidVO {

    //("id")
    private Long id;
    //("所属组织")
    private Long orgId;
    //("所属组织名称")
    private String orgName;
    //("单据编码")
    private String billCode;
    //("单据状态")
    private Integer billState;
    //("工程id")
    private Long enrollId;
    //("工程编码")
    private String engineeringCode;
    //("工程名称")
    private String engineeringName;
    //("开标日期(格式：yyyy-mm-dd)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date openTenderDate;
    //("评标办法id  (自定义档案)")
    private Long bidEvaluationId;
    //("评标办法")
    private String bidEvaluationMethod;
    //("项目负责人")
    private String projectLeader;
    //("建造师")
    private String architect;
    //("投标结果 0 已中标 1 未中标")
    private Integer bidResult;
    //("中标单位id")
    private Long bidWinnerId;
    //("中标单位")
    private String bidWinner;
    //("开标地点")
    private String bidOpeningPlace;
    //("中标日期(格式：yyyy-mm-dd)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date winBiddingDate;
    //("报价形式 0:总价 1:费率")
    private Integer quotationForm;
    //("中标金额  （单位万元）")
    private BigDecimal bidMmy;
    //("招标控制价（单位万元）")
    private BigDecimal biddingControlMmy;
    //("报价下浮率（控制价）% ")
    private BigDecimal quoteLowerRate;
    //("投标报价费率 ")
    private BigDecimal bidQuotationRate;
    //("招标控制价费率")
    private BigDecimal biddingControlRate;
    //("报价下浮率（控制价）%")
    private BigDecimal controlQuoteLowerRate;
    //("工期")
    private BigDecimal duration;
    //("投标单位id")
    private Long bidUnitId;
    //("投标单位")
    private String bidUnit;
    //("单位负责人id")
    private Long unitLeaderId;
    //("投标代理人")
    private String biddingAgent;
    //("单位负责人")
    private String unitLeader;
    //("质量目标")
    private String qualityTarget;
    //("投标标段数量")
    private Integer bidSectionNumber;
    //("中标标段")
    private String bidWinningSection;
    //("备注")
    private String remarks;
    //("中标通知书返回状态 0 未选择 1 选择")
    private Integer notificationStatus;
    //("中标单位信息")
    private String bidWinnerNews;
    //("是否中标")
    private Integer isBidWinning;
    //("工程类别")
    private Long engineeringType;
    //("工程类别")
    private String engineeringTypeName;
    //("省份")
    private String province;
    //("市")
    private String city;
    //("区县")
    private String region;
    //("区划编码")
    private String adcode;
    private Integer total;
    private Integer sumBidWinningNumber;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 工程id
     */
    @ReferSerialTransfer(referCode = "bid-enroll")
    public Long getEnrollId() {
        return enrollId;
    }
    /**
     * 工程id
     */
    @ReferDeserialTransfer
    public void setEnrollId(Long enrollId) {
        this.enrollId = enrollId;
    }


    /**
     * 工程编码
     */
    public String getEngineeringCode() {
        return engineeringCode;
    }

    /**
     * 工程编码
     */
    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    /**
     * 开标日期(格式：yyyy-mm-dd)
     */
    public Date getOpenTenderDate() {
        return openTenderDate;
    }

    /**
     * 开标日期(格式：yyyy-mm-dd)
     */
    public void setOpenTenderDate(Date openTenderDate) {
        this.openTenderDate = openTenderDate;
    }
    /**
     * 评标办法id  (自定义档案)
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBidEvaluationId() {
        return bidEvaluationId;
    }

    /**
     * 评标办法id  (自定义档案)
     */
    @ReferDeserialTransfer
    public void setBidEvaluationId(Long bidEvaluationId) {
        this.bidEvaluationId = bidEvaluationId;
    }
    /**
     * 评标办法
     */
    public String getBidEvaluationMethod() {
        return bidEvaluationMethod;
    }

    /**
     * 评标办法
     */
    public void setBidEvaluationMethod(String bidEvaluationMethod) {
        this.bidEvaluationMethod = bidEvaluationMethod;
    }
    /**
     * 项目负责人
     */
    public String getProjectLeader() {
        return projectLeader;
    }

    /**
     * 项目负责人
     */
    public void setProjectLeader(String projectLeader) {
        this.projectLeader = projectLeader;
    }
    /**
     * 建造师
     */
    public String getArchitect() {
        return architect;
    }

    /**
     * 建造师
     */
    public void setArchitect(String architect) {
        this.architect = architect;
    }

    /**
     * 投标结果 0 已中标 1 未中标
     */
    public Integer getBidResult() {
        return bidResult;
    }

    /**
     * 投标结果 0 已中标 1 未中标
     */
    public void setBidResult(Integer bidResult) {
        this.bidResult = bidResult;
    }
    /**
     * 中标单位id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBidWinnerId() {
        return bidWinnerId;
    }

    /**
     * 中标单位id
     */
    @ReferDeserialTransfer
    public void setBidWinnerId(Long bidWinnerId) {
        this.bidWinnerId = bidWinnerId;
    }
    /**
     * 中标单位
     */
    public String getBidWinner() {
        return bidWinner;
    }

    /**
     * 中标单位
     */
    public void setBidWinner(String bidWinner) {
        this.bidWinner = bidWinner;
    }
    /**
     * 开标地点
     */
    public String getBidOpeningPlace() {
        return bidOpeningPlace;
    }

    /**
     * 开标地点
     */
    public void setBidOpeningPlace(String bidOpeningPlace) {
        this.bidOpeningPlace = bidOpeningPlace;
    }
    /**
     * 中标日期(格式：yyyy-mm-dd)
     */
    public Date getWinBiddingDate() {
        return winBiddingDate;
    }

    /**
     * 中标日期(格式：yyyy-mm-dd)
     */
    public void setWinBiddingDate(Date winBiddingDate) {
        this.winBiddingDate = winBiddingDate;
    }
    /**
     * 报价形式 0:总价 1:费率
     */
    public Integer getQuotationForm() {
        return quotationForm;
    }

    /**
     * 报价形式 0:总价 1:费率
     */
    public void setQuotationForm(Integer quotationForm) {
        this.quotationForm = quotationForm;
    }
    /**
     * 中标金额  （单位万元）
     */
    public BigDecimal getBidMmy() {
        return bidMmy;
    }

    /**
     * 中标金额  （单位万元）
     */
    public void setBidMmy(BigDecimal bidMmy) {
        this.bidMmy = bidMmy;
    }
    /**
     * 招标控制价（单位万元）
     */
    public BigDecimal getBiddingControlMmy() {
        return biddingControlMmy;
    }

    /**
     * 招标控制价（单位万元）
     */
    public void setBiddingControlMmy(BigDecimal biddingControlMmy) {
        this.biddingControlMmy = biddingControlMmy;
    }
    /**
     * 报价下浮率（控制价）%
     */
    public BigDecimal getQuoteLowerRate() {
        return quoteLowerRate;
    }

    /**
     * 报价下浮率（控制价）%
     */
    public void setQuoteLowerRate(BigDecimal quoteLowerRate) {
        this.quoteLowerRate = quoteLowerRate;
    }
    /**
     * 投标报价费率
     */
    public BigDecimal getBidQuotationRate() {
        return bidQuotationRate;
    }

    /**
     * 投标报价费率
     */
    public void setBidQuotationRate(BigDecimal bidQuotationRate) {
        this.bidQuotationRate = bidQuotationRate;
    }
    /**
     * 招标控制价费率
     */
    public BigDecimal getBiddingControlRate() {
        return biddingControlRate;
    }

    /**
     * 招标控制价费率
     */
    public void setBiddingControlRate(BigDecimal biddingControlRate) {
        this.biddingControlRate = biddingControlRate;
    }
    /**
     * 报价下浮率（控制价）%
     */
    public BigDecimal getControlQuoteLowerRate() {
        return controlQuoteLowerRate;
    }

    /**
     * 报价下浮率（控制价）%
     */
    public void setControlQuoteLowerRate(BigDecimal controlQuoteLowerRate) {
        this.controlQuoteLowerRate = controlQuoteLowerRate;
    }
    /**
     * 工期
     */
    public BigDecimal getDuration() {
        return duration;
    }

    /**
     * 工期
     */
    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    /**
     * 投标单位id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBidUnitId() {
        return bidUnitId;
    }

    /**
     * 投标单位id
     */
    @ReferDeserialTransfer
    public void setBidUnitId(Long bidUnitId) {
        this.bidUnitId = bidUnitId;
    }
    /**
     * 投标单位
     */
    public String getBidUnit() {
        return bidUnit;
    }

    /**
     * 投标单位
     */
    public void setBidUnit(String bidUnit) {
        this.bidUnit = bidUnit;
    }
    /**
     * 单位负责人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getUnitLeaderId() {
        return unitLeaderId;
    }

    /**
     * 单位负责人id
     */
    @ReferDeserialTransfer
    public void setUnitLeaderId(Long unitLeaderId) {
        this.unitLeaderId = unitLeaderId;
    }
    /**
     * 单位负责人
     */
    public String getUnitLeader() {
        return unitLeader;
    }
    /**
     * 投标代理人
     */
    public String getBiddingAgent() {
        return biddingAgent;
    }
    /**
     * 投标代理人
     */
    public void setBiddingAgent(String biddingAgent) {
        this.biddingAgent = biddingAgent;
    }

    /**
     * 单位负责人
     */
    public void setUnitLeader(String unitLeader) {
        this.unitLeader = unitLeader;
    }
    /**
     * 质量目标
     */
    public String getQualityTarget() {
        return qualityTarget;
    }

    /**
     * 质量目标
     */
    public void setQualityTarget(String qualityTarget) {
        this.qualityTarget = qualityTarget;
    }
    /**
     * 投标标段数量
     */
    public Integer getBidSectionNumber() {
        return bidSectionNumber;
    }

    /**
     * 投标标段数量
     */
    public void setBidSectionNumber(Integer bidSectionNumber) {
        this.bidSectionNumber = bidSectionNumber;
    }
    /**
     * 中标标段
     */
    public String getBidWinningSection() {
        return bidWinningSection;
    }

    /**
     * 中标标段
     */
    public void setBidWinningSection(String bidWinningSection) {
        this.bidWinningSection = bidWinningSection;
    }

    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 中标通知书返回状态 0 未选择 1 选择
     */
    public Integer getNotificationStatus() {
        return notificationStatus;
    }

    /**
     * 中标通知书返回状态 0 未选择 1 选择
     */
    public void setNotificationStatus(Integer notificationStatus) {
        this.notificationStatus = notificationStatus;
    }
    /**
     * 中标单位信息
     */
    public String getBidWinnerNews() {
        return bidWinnerNews;
    }

    /**
     * 中标单位信息
     */
    public void setBidWinnerNews(String bidWinnerNews) {
        this.bidWinnerNews = bidWinnerNews;
    }
    /**
     * 是否中标
     */
    public Integer getIsBidWinning() {
        return isBidWinning;
    }

    /**
     * 是否中标
     */
    public void setIsBidWinning(Integer isBidWinning) {
        this.isBidWinning = isBidWinning;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getAdcode() {
        return adcode;
    }

    public void setAdcode(String adcode) {
        this.adcode = adcode;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getSumBidWinningNumber() {
        return sumBidWinningNumber;
    }

    public void setSumBidWinningNumber(Integer sumBidWinningNumber) {
        this.sumBidWinningNumber = sumBidWinningNumber;
    }
}
