package com.ejianc.business.steelstructure.other.recipetApply.api;

import com.ejianc.business.steelstructure.other.recipetApply.hystrix.WbRecipetApplyHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

@FeignClient(name= "ejc-steelstructure-web", url="${common.env.feign-client-url}", path="ejc-steelstructure-web", fallback = WbRecipetApplyHystrix.class)
public interface IWbRecipetApplyApi {

    /**
     * //yn
     * 根据项目查项目预算金额
     * @param  mny 实际收款金额
     * @param  id 收款申请单id
     * @param  flag true/false
     * @return
     */
    @GetMapping ("/api/WbRecipetApplyApi/wbActualReceivedMny")
    public CommonResponse<String> wbActualReceivedMny(@RequestParam(value = "mny") BigDecimal mny,@RequestParam(value = "id") Long id,@RequestParam(value = "flag") boolean flag);
}
