package com.ejianc.business.steelstructure.promaterial.contract.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 变更-合同条款实体
 * 
 * @author generator
 * 
 */
@ApiModel("变更-合同条款实体")
public class PromaterialContractChangeClauseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("合同条款名称Id")
    private Long clauseId;
    @ApiModelProperty("合同条款名称")
    private String clauseName;
    @ApiModelProperty("合同条款内容")
    private String clauseContent;
    @ApiModelProperty("所属合同Id")
    private Long contractId;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更子表主键")
    private Long changeBid;
    private Long srcTblId; // 来源子表主键
    /**
     * 是否必填 0否  1是
     */
    private Integer necessaryStatus;

    public Integer getNecessaryStatus() {
        return necessaryStatus;
    }

    public void setNecessaryStatus(Integer necessaryStatus) {
        this.necessaryStatus = necessaryStatus;
    }
    /**
     * 对比清单使用字段——原合同条款内容
     *
     */
    private String beforeChangeClauseContent;

    /**
     * 对比清单使用字段——变更类型：0-新增项，1-删除项，2-条款内容便更
     */
    private String changeType;

    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }
    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getBeforeChangeClauseContent() {
        return beforeChangeClauseContent;
    }

    public void setBeforeChangeClauseContent(String beforeChangeClauseContent) {
        this.beforeChangeClauseContent = beforeChangeClauseContent;
    }

    /**
     * 合同条款名称Id
     */
    @ReferSerialTransfer(referCode="contractClause")
    public Long getClauseId() {
        return clauseId;
    }

    /**
     * 合同条款名称Id
     */
    @ReferDeserialTransfer
    public void setClauseId(Long clauseId) {
        this.clauseId = clauseId;
    }
    /**
     * 合同条款名称
     */
    public String getClauseName() {
        return clauseName;
    }

    /**
     * 合同条款名称
     */
    public void setClauseName(String clauseName) {
        this.clauseName = clauseName;
    }
    /**
     * 合同条款内容
     */
    public String getClauseContent() {
        return clauseContent;
    }

    /**
     * 合同条款内容
     */
    public void setClauseContent(String clauseContent) {
        this.clauseContent = clauseContent;
    }
    /**
     * 所属合同Id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 所属合同Id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    
}
