package com.ejianc.business.steelstructure.promaterial.contract.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 变更-合同付款阶段实体
 * 
 * @author generator
 * 
 */
@ApiModel("变更-合同付款阶段实体")
public class PromaterialContractChangeStageVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("付款阶段名称")
    private String stageName;
    @ApiModelProperty("付款阶段比例(%)")
    private BigDecimal stageScale;
    @ApiModelProperty("备注")
    private String stageMemo;
    @ApiModelProperty("所属合同Id")
    private Long contractId;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更子表主键")
    private Long changeBid;
    private Long srcTblId; // 来源子表主键
    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }
    /**
     * 对比清单使用字段——原名称
     *
     */
    private String beforePaymentName;

    /**
     * 对比清单使用字段——原比例
     */
    private BigDecimal beforePaymentScale;

    /**
     * 对比清单使用字段——变更类型：0-新增项，1-删除项，2-条款内容便更
     */
    private String changeType;

    public String getBeforePaymentName() {
        return beforePaymentName;
    }

    public void setBeforePaymentName(String beforePaymentName) {
        this.beforePaymentName = beforePaymentName;
    }

    public BigDecimal getBeforePaymentScale() {
        return beforePaymentScale;
    }

    public void setBeforePaymentScale(BigDecimal beforePaymentScale) {
        this.beforePaymentScale = beforePaymentScale;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    /**
     * 付款阶段名称
     */
    public String getStageName() {
        return stageName;
    }

    /**
     * 付款阶段名称
     */
    public void setStageName(String stageName) {
        this.stageName = stageName;
    }
    /**
     * 付款阶段比例(%)
     */
    public BigDecimal getStageScale() {
        return stageScale;
    }

    /**
     * 付款阶段比例(%)
     */
    public void setStageScale(BigDecimal stageScale) {
        this.stageScale = stageScale;
    }
    /**
     * 备注
     */
    public String getStageMemo() {
        return stageMemo;
    }

    /**
     * 备注
     */
    public void setStageMemo(String stageMemo) {
        this.stageMemo = stageMemo;
    }
    /**
     * 所属合同Id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 所属合同Id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    
}
