package com.ejianc.business.steelstructure.promaterial.pricelib.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 价格库-结算明细
 * 
 * @author generator
 * 
 */
@ApiModel("价格库-结算明细")
public class PriceSettlementVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织编码")
    private String orgCode;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("项目地区")
    private String area;
    @ApiModelProperty("项目地区")
    private String areaName;
    @ApiModelProperty("乙方Id")
    private Long supplierId;
    @ApiModelProperty("乙方名称")
    private String supplierName;
    @ApiModelProperty("结算日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementDate;
    @ApiModelProperty("来源主表id")
    private Long sourceId;
    @ApiModelProperty("来源子表id")
    private Long sourceDetailId;
    @ApiModelProperty("类型（0-物资采购结算单，1-混凝土结算单）")
    private Integer settlementType;
    @ApiModelProperty("结算付款")
    private String settlementPayment;
    @ApiModelProperty("单价浮动方式")
    private String priceFloatType;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物料Id")
    private Long materialId;
    @ApiModelProperty("物资分类Id")
    private Long materialTypeId;
    @ApiModelProperty("物资分类名称")
    private String materialTypeName;
    @ApiModelProperty("分类内码")
    private String innerCode;
    @ApiModelProperty("规则/型号")
    private String spec;
    @ApiModelProperty("计量单位主键")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unitName;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("数量")
    private BigDecimal settleNum;
    @ApiModelProperty("税率")
    private BigDecimal settleTaxRate;
    @ApiModelProperty("单价(无税)")
    private BigDecimal settlePrice;
    @ApiModelProperty("单价(含税)")
    private BigDecimal settleTaxPrice;
    @ApiModelProperty("金额(无税)")
    private BigDecimal settleMny;
    @ApiModelProperty("金额(含税)")
    private BigDecimal settleTaxMny;
    @ApiModelProperty("税额")
    private BigDecimal settleTax;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("来源单据编号")
    private String sourceCode;
    @ApiModelProperty("是否移除（0-否未移除，1-是）")
    private Integer outFlag;

    private String settleUrl;

    public String getSettleUrl() {
        return settleUrl;
    }

    public void setSettleUrl(String settleUrl) {
        this.settleUrl = settleUrl;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 项目地区
     */
    public String getArea() {
        return area;
    }

    /**
     * 项目地区
     */
    public void setArea(String area) {
        this.area = area;
    }
    /**
     * 项目地区
     */
    public String getAreaName() {
        return areaName;
    }

    /**
     * 项目地区
     */
    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    /**
     * 乙方Id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 乙方Id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 结算日期
     */
    public Date getSettlementDate() {
        return settlementDate;
    }

    /**
     * 结算日期
     */
    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    /**
     * 来源主表id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主表id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源子表id
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源子表id
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 类型（0-物资采购结算单，1-混凝土结算单）
     */
    public Integer getSettlementType() {
        return settlementType;
    }

    /**
     * 类型（0-物资采购结算单，1-混凝土结算单）
     */
    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }
    /**
     * 结算付款
     */
    public String getSettlementPayment() {
        return settlementPayment;
    }

    /**
     * 结算付款
     */
    public void setSettlementPayment(String settlementPayment) {
        this.settlementPayment = settlementPayment;
    }
    /**
     * 单价浮动方式
     */
    public String getPriceFloatType() {
        return priceFloatType;
    }
    /**
     * 单价浮动方式
     */
    public void setPriceFloatType(String priceFloatType) {
        this.priceFloatType = priceFloatType;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物料Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物料Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 分类内码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 分类内码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    /**
     * 规则/型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规则/型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 计量单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 数量
     */
    public BigDecimal getSettleNum() {
        return settleNum;
    }

    /**
     * 数量
     */
    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }
    /**
     * 税率
     */
    public BigDecimal getSettleTaxRate() {
        return settleTaxRate;
    }

    /**
     * 税率
     */
    public void setSettleTaxRate(BigDecimal settleTaxRate) {
        this.settleTaxRate = settleTaxRate;
    }
    /**
     * 单价(无税)
     */
    public BigDecimal getSettlePrice() {
        return settlePrice;
    }

    /**
     * 单价(无税)
     */
    public void setSettlePrice(BigDecimal settlePrice) {
        this.settlePrice = settlePrice;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getSettleTaxPrice() {
        return settleTaxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setSettleTaxPrice(BigDecimal settleTaxPrice) {
        this.settleTaxPrice = settleTaxPrice;
    }
    /**
     * 金额(无税)
     */
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    /**
     * 金额(无税)
     */
    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    /**
     * 金额(含税)
     */
    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    /**
     * 金额(含税)
     */
    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    /**
     * 税额
     */
    public BigDecimal getSettleTax() {
        return settleTax;
    }

    /**
     * 税额
     */
    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 来源单据编号
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源单据编号
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 是否移除（0-否未移除，1-是）
     */
    public Integer getOutFlag() {
        return outFlag;
    }

    /**
     * 是否移除（0-否未移除，1-是）
     */
    public void setOutFlag(Integer outFlag) {
        this.outFlag = outFlag;
    }
    
}
