package com.ejianc.business.steelstructure.promaterial.reconciliation.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 对账明细表
 * 
 * @author generator
 * 
 */
@ApiModel("对账明细表")
public class SupReconciliationDetailVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("对账主键ID")
    private Long reconciliationId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(验收—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型（0-验收，1-退货）")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("规格型号")
    private String spec;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("入库日期")
    private Date storeDate;
    @ApiModelProperty("入库数量")
    private BigDecimal storeNum;
    @ApiModelProperty("对账数量")
    private BigDecimal reconciliationNum;
    @ApiModelProperty("入库单价")
    private BigDecimal price;
    @ApiModelProperty("入库单价(含税)")
    private BigDecimal taxPrice;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("对账金额")
    private BigDecimal mny;
    @ApiModelProperty("对账金额(含税)")
    private BigDecimal taxMny;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    private Integer reconciliationState; // 对账单状态（0-为引用,1-已引用）
    private String admixtureId; // 外加剂Id
    private String admixtureName; // 外加剂名称
    private BigDecimal admixturePrice; // 外加剂综合单价

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAdmixtureId() {
        return admixtureId;
    }

    public void setAdmixtureId(String admixtureId) {
        this.admixtureId = admixtureId;
    }

    public String getAdmixtureName() {
        return admixtureName;
    }

    public void setAdmixtureName(String admixtureName) {
        this.admixtureName = admixtureName;
    }

    public BigDecimal getAdmixturePrice() {
        return admixturePrice;
    }

    public void setAdmixturePrice(BigDecimal admixturePrice) {
        this.admixturePrice = admixturePrice;
    }

    public Integer getReconciliationState() {
        return reconciliationState;
    }

    public void setReconciliationState(Integer reconciliationState) {
        this.reconciliationState = reconciliationState;
    }
    

    /**
     * 对账主键ID
     */
    public Long getReconciliationId() {
        return reconciliationId;
    }

    /**
     * 对账主键ID
     */
    public void setReconciliationId(Long reconciliationId) {
        this.reconciliationId = reconciliationId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源类型名称(验收—100231)
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称(验收—100231)
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源类型（0-验收，1-退货）
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型（0-验收，1-退货）
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源编码
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源编码
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 入库日期
     */
    public Date getStoreDate() {
        return storeDate;
    }

    /**
     * 入库日期
     */
    public void setStoreDate(Date storeDate) {
        this.storeDate = storeDate;
    }
    /**
     * 入库数量
     */
    public BigDecimal getStoreNum() {
        return storeNum;
    }

    /**
     * 入库数量
     */
    public void setStoreNum(BigDecimal storeNum) {
        this.storeNum = storeNum;
    }
    /**
     * 对账数量
     */
    public BigDecimal getReconciliationNum() {
        return reconciliationNum;
    }

    /**
     * 对账数量
     */
    public void setReconciliationNum(BigDecimal reconciliationNum) {
        this.reconciliationNum = reconciliationNum;
    }
    /**
     * 入库单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 入库单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 入库单价(含税)
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 入库单价(含税)
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 对账金额
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 对账金额
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 对账金额(含税)
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 对账金额(含税)
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    
}
