package com.ejianc.business.steelstructure.promaterial.settlement.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.steelstructure.promaterial.settlement.hystrix.IProMaterialSettleHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(
        name = "ejc-promaterial-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-promaterial-web",
        fallback = IProMaterialSettleHystrix.class
)
public interface IProMaterialSettleApi {
    /**
     * 根据 项目无合同所有状态下材料、混凝土结算金额之和
     *
     * @return
     */
    @RequestMapping(
            value = {"/api/proMaterialSettle/querySettleMnyProjectId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<JSONObject> querySettleMnyProjectId(@RequestParam("projectId") Long projectId);
}
