package com.ejianc.business.steelstructure.promaterial.settlement.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 合同结算记录
 *
 */
public class PromaterialContractSettlementRecordVO extends BaseVO {
    private static final long serialVersionUID = 2718875112397717352L;

    private boolean canAddNewSettleFlag;

    /**
     * 合同Id
     */
    private Long contractId;
    /**
     * 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    private String performanceStatus;

    /**
     * 合同金额含税
     */
    private BigDecimal contractTaxMny;


    /**
     * 结算比例
     */
    private BigDecimal settleRate;

    /**
     * 合同结算金额
     */
    private BigDecimal contractSettleMny;
    /**
     *
     */
    List<PromaterialSettlementVO> settleList = new ArrayList<>();

    public boolean isCanAddNewSettleFlag() {
        return canAddNewSettleFlag;
    }

    public void setCanAddNewSettleFlag(boolean canAddNewSettleFlag) {
        this.canAddNewSettleFlag = canAddNewSettleFlag;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getSettleRate() {
        return settleRate;
    }

    public void setSettleRate(BigDecimal settleRate) {
        this.settleRate = settleRate;
    }

    public BigDecimal getContractSettleMny() {
        return contractSettleMny;
    }

    public void setContractSettleMny(BigDecimal contractSettleMny) {
        this.contractSettleMny = contractSettleMny;
    }

    public List<PromaterialSettlementVO> getSettleList() {
        return settleList;
    }

    public void setSettleList(List<PromaterialSettlementVO> settleList) {
        this.settleList = settleList;
    }
}
