package com.ejianc.business.steelstructure.prosub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 结算子表-奖罚扣款单
 *
 * @author generator
 */
public class SettleDeductVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer useFlag; // 是否引用过,否-0，是-1
    private Long settleId; // 结算id
    private Long contractId; // 合同id
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    private Long projectId; // 项目Id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    private Long sourceId; // 奖罚扣款单id
    private String sourceBillCode; // 单据单号
    private Integer rewardDeductionType; // 单据类型:默认奖励,奖励-0、扣款-1、罚款-2
    private BigDecimal deductTaxMny; // 金额
    private BigDecimal deductMny; // 金额(无税)
    private BigDecimal deductTax; // 税额
    private BigDecimal deductTaxRate; // 税率
    private Integer inputCostFlag; // 是否入成本,否-0，是-1
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date happenDate; // 发生日期
    private String memo; // 非必填，0-30字

    private Long deductWbsId; // 核算对象主键
    private String deductWbsName; // 核算对象名称
    private String deductWbsCode; // 核算对象编码
    private Long deductSubjectId; // 成本科目主键
    private String deductSubjectName; // 成本科目名称
    private String deductSubjectCode; // 成本科目编码

    public Long getDeductWbsId() {
        return deductWbsId;
    }
    @ReferDeserialTransfer
    public void setDeductWbsId(Long deductWbsId) {
        this.deductWbsId = deductWbsId;
    }

    public String getDeductWbsName() {
        return deductWbsName;
    }

    public void setDeductWbsName(String deductWbsName) {
        this.deductWbsName = deductWbsName;
    }

    public String getDeductWbsCode() {
        return deductWbsCode;
    }

    public void setDeductWbsCode(String deductWbsCode) {
        this.deductWbsCode = deductWbsCode;
    }

    public Long getDeductSubjectId() {
        return deductSubjectId;
    }
    @ReferDeserialTransfer
    public void setDeductSubjectId(Long deductSubjectId) {
        this.deductSubjectId = deductSubjectId;
    }

    public String getDeductSubjectName() {
        return deductSubjectName;
    }

    public void setDeductSubjectName(String deductSubjectName) {
        this.deductSubjectName = deductSubjectName;
    }

    public String getDeductSubjectCode() {
        return deductSubjectCode;
    }

    public void setDeductSubjectCode(String deductSubjectCode) {
        this.deductSubjectCode = deductSubjectCode;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Integer getRewardDeductionType() {
        return rewardDeductionType;
    }

    public void setRewardDeductionType(Integer rewardDeductionType) {
        this.rewardDeductionType = rewardDeductionType;
    }

    public BigDecimal getDeductTaxMny() {
        return deductTaxMny;
    }

    public void setDeductTaxMny(BigDecimal deductTaxMny) {
        this.deductTaxMny = deductTaxMny;
    }

    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }

    public BigDecimal getDeductTax() {
        return deductTax;
    }

    public void setDeductTax(BigDecimal deductTax) {
        this.deductTax = deductTax;
    }

    public BigDecimal getDeductTaxRate() {
        return deductTaxRate;
    }

    public void setDeductTaxRate(BigDecimal deductTaxRate) {
        this.deductTaxRate = deductTaxRate;
    }

    public Integer getInputCostFlag() {
        return inputCostFlag;
    }

    public void setInputCostFlag(Integer inputCostFlag) {
        this.inputCostFlag = inputCostFlag;
    }

    public Date getHappenDate() {
        return happenDate;
    }

    public void setHappenDate(Date happenDate) {
        this.happenDate = happenDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
