package com.ejianc.business.steelstructure.prosub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 结算子表-领料结算
 *
 * @author generator
 */
public class SettlePickingVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer useFlag; // 是否引用过,否-0，是-1
    private Long settleId; // 结算id
    private Long contractId; // 合同id
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    private Long projectId; // 项目Id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    private Long sourceId; // 领料结算id
    private String sourceBillCode; // 单据单号
    private BigDecimal pickingTaxMny; // 领料扣款金额
    private BigDecimal pickingMny; // 领料扣款金额(无税)
    private BigDecimal pickingTax; // 领料扣款金额税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date pickingDate; // 领料结算日期
    private String memo; // 备注 默认为空，非必填，0-30字
    private Long pickingWbsId; // 核算对象主键
    private String pickingWbsName; // 核算对象名称
    private String pickingWbsCode; // 核算对象编码
    private Long pickingSubjectId; // 成本科目主键
    private String pickingSubjectName; // 成本科目名称
    private String pickingSubjectCode; // 成本科目编码

    private BigDecimal costMny; // '成本金额'
    private BigDecimal costTaxMny; // 成本金额（含税）
    private BigDecimal costTax; // 成本税额

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }

    public BigDecimal getCostTax() {
        return costTax;
    }

    public void setCostTax(BigDecimal costTax) {
        this.costTax = costTax;
    }

    public Long getPickingWbsId() {
        return pickingWbsId;
    }
    @ReferDeserialTransfer
    public void setPickingWbsId(Long pickingWbsId) {
        this.pickingWbsId = pickingWbsId;
    }

    public String getPickingWbsName() {
        return pickingWbsName;
    }

    public void setPickingWbsName(String pickingWbsName) {
        this.pickingWbsName = pickingWbsName;
    }

    public String getPickingWbsCode() {
        return pickingWbsCode;
    }

    public void setPickingWbsCode(String pickingWbsCode) {
        this.pickingWbsCode = pickingWbsCode;
    }

    public Long getPickingSubjectId() {
        return pickingSubjectId;
    }
    @ReferDeserialTransfer
    public void setPickingSubjectId(Long pickingSubjectId) {
        this.pickingSubjectId = pickingSubjectId;
    }

    public String getPickingSubjectName() {
        return pickingSubjectName;
    }

    public void setPickingSubjectName(String pickingSubjectName) {
        this.pickingSubjectName = pickingSubjectName;
    }

    public String getPickingSubjectCode() {
        return pickingSubjectCode;
    }

    public void setPickingSubjectCode(String pickingSubjectCode) {
        this.pickingSubjectCode = pickingSubjectCode;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public BigDecimal getPickingTaxMny() {
        return pickingTaxMny;
    }

    public void setPickingTaxMny(BigDecimal pickingTaxMny) {
        this.pickingTaxMny = pickingTaxMny;
    }

    public BigDecimal getPickingMny() {
        return pickingMny;
    }

    public void setPickingMny(BigDecimal pickingMny) {
        this.pickingMny = pickingMny;
    }

    public BigDecimal getPickingTax() {
        return pickingTax;
    }

    public void setPickingTax(BigDecimal pickingTax) {
        this.pickingTax = pickingTax;
    }

    public Date getPickingDate() {
        return pickingDate;
    }

    public void setPickingDate(Date pickingDate) {
        this.pickingDate = pickingDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
