package com.ejianc.business.store.api;

import com.ejianc.business.store.hystrix.StoreApiHystrix;
import com.ejianc.business.store.vo.AllotOutVO;
import com.ejianc.business.store.vo.StoreVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(name = "ejc-store-web", url = "${common.env.feign-client-url}", path = "ejc-store-web", fallback = StoreApiHystrix.class)
public interface IStoreApi {

    @RequestMapping(value = "/api/store/queryStoreByProject", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<StoreVO> queryStoreByProject(@RequestParam Long projectId, @RequestParam Integer attrFlag);

    /**
     * @description: 生成调拨出库单
     * @author sunyj
     * @date: 2023/12/19
     */
    @RequestMapping(value = "/api/store/changeToAllouOut", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<AllotOutVO> changeToAllouOut(@RequestBody AllotOutVO allotOutVO);
}
