package com.ejianc.business.store.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public  enum ManageTypeEnum {
    SUB("1","分包仓库"),
    PROJ("2","项目仓库");

    private String code;

    private String description;

    private static Map<Integer, ManageTypeEnum> enumMap = new HashMap();
    //构造方法
    private ManageTypeEnum(String code, String description ){
        this.code = code;
        this.description = description;
    }

    public static ManageTypeEnum getEnumByStateCode(Integer billStateCode) {
        return (ManageTypeEnum)enumMap.get(billStateCode);
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    static {
        enumMap = (Map) EnumSet.allOf(ManageTypeEnum.class).stream().collect(Collectors.toMap(ManageTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
