package com.ejianc.business.store.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 仓库表
 *
 * @author generator
 *
 */
public class StoreVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long orgId; // 所属项目部
    private String orgName; // 所属项目部名称
    private Long projectId; // 所属项目
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private Integer projectType; // 是否项目（1、是，0、否）
    private Long parentOrgId; // 项目部上级组织
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Integer state; // 仓库状态（1、启用，0、停用）
    private String name; // 仓库名称
    private Integer attrFlag; // 仓库属性 1-自购材；2-甲供材
    private BigDecimal totalMny; // 库存金额
    private Integer defaultFlag; // 是否默认：0-否；1-是
    private String memo; // 描述

    private String orgCode; // 项目组织编码

    private String code;

    private Integer manageType; // 管理属性 1-分包仓库 2-项目仓库；
    private Long subContractId; // 分包合同主键
    private String subContractName; // 分包合同名称
    private String subContractCode; // 分包合同code
    private Long subSupplierId; // 分包合同供应商主键
    private String subSupplierName; // 分包合同供应商名称
    private Long storeManagerId; // 仓库管理员Id
    private String storeManagerName; // 仓库管理员名称
    private Integer storeManagerType; // 仓库管理员属性：1-专职2-兼职
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Integer billState; // 单据状态
    private String billCode;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }


    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Integer getProjectType() {
        return projectType;
    }

    public void setProjectType(Integer projectType) {
        this.projectType = projectType;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getAttrFlag() {
        return attrFlag;
    }

    public void setAttrFlag(Integer attrFlag) {
        this.attrFlag = attrFlag;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public Integer getDefaultFlag() {
        return defaultFlag;
    }

    public void setDefaultFlag(Integer defaultFlag) {
        this.defaultFlag = defaultFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getManageType() {
        return manageType;
    }

    public void setManageType(Integer manageType) {
        this.manageType = manageType;
    }

    @ReferSerialTransfer(referCode = "proSubContract")
    public Long getSubContractId() {
        return subContractId;
    }

    @ReferDeserialTransfer
    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }

    public String getSubContractName() {
        return subContractName;
    }

    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }

    public String getSubContractCode() {
        return subContractCode;
    }

    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSubSupplierId() {
        return subSupplierId;
    }

    @ReferDeserialTransfer
    public void setSubSupplierId(Long subSupplierId) {
        this.subSupplierId = subSupplierId;
    }

    public String getSubSupplierName() {
        return subSupplierName;
    }

    public void setSubSupplierName(String subSupplierName) {
        this.subSupplierName = subSupplierName;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getStoreManagerId() {
        return storeManagerId;
    }

    @ReferDeserialTransfer
    public void setStoreManagerId(Long storeManagerId) {
        this.storeManagerId = storeManagerId;
    }

    public String getStoreManagerName() {
        return storeManagerName;
    }

    public void setStoreManagerName(String storeManagerName) {
        this.storeManagerName = storeManagerName;
    }

    public Integer getStoreManagerType() {
        return storeManagerType;
    }

    public void setStoreManagerType(Integer storeManagerType) {
        this.storeManagerType = storeManagerType;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
}
