package com.ejianc.business.store.vo;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 仓库材料处置明细表
 *
 * @author generator
 *
 */
public class HandleDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long handleId; // 处置ID
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialTypeCode")
    private Long materialCategoryId; // 物资分类Id
    private String materialTypeCode;
    private String materialCategoryName; // 物资分类名称
    @ReferJsonField(referCode = "Material001",referFields = "code",resultFields = "materialCode")
    private Long materialId; // 物资Id
    private String materialCode;
    private String materialName; // 物资名称
    private String spec; // 规格型号
    private Long unit; // 计量单位
    private String unitName; // 计量单位
    private BigDecimal surplusNum; // 库存余量
    private BigDecimal handlePrice; // 处置单价
    private BigDecimal handleNum; // 处置数量
    private BigDecimal inStoreAvg; // 入库均价
    private BigDecimal handleMny; // 处置金额
    private BigDecimal inStoreTaxMny; // 入库金额
    private BigDecimal inStoreTax; // 入库税额
    private BigDecimal inStoreMny; // 入库金额(无税)
    private BigDecimal handleSubTaxMny; // 处置差额
    private BigDecimal handleSubMny; // 处置差额(无税)
    private String memo; // 备注

    private BigDecimal handleTaxMny; // 处置金额(含税)
    private Long wbsId; // 核算对象id
    private String wbsCode; // 核算对象code
    private String wbsName; // 核算对象name
    private Long subjectId; // 成本科目id
    private String subjectCode; // 成本科目code
    private String subjectName; // 成本科目name

    private BigDecimal handleTaxPrice; // 处置单价（含税）
    private BigDecimal taxRate; // 税率
    private BigDecimal handleTax; // 处置税额

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public BigDecimal getHandleTaxMny() {
        return handleTaxMny;
    }

    public void setHandleTaxMny(BigDecimal handleTaxMny) {
        this.handleTaxMny = handleTaxMny;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }

    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getHandleId() {
        return handleId;
    }

    public void setHandleId(Long handleId) {
        this.handleId = handleId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnit() {
        return unit;
    }

    public void setUnit(Long unit) {
        this.unit = unit;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }
    public BigDecimal getHandlePrice() {
        return handlePrice;
    }

    public void setHandlePrice(BigDecimal handlePrice) {
        this.handlePrice = handlePrice;
    }
    public BigDecimal getHandleNum() {
        return handleNum;
    }

    public void setHandleNum(BigDecimal handleNum) {
        this.handleNum = handleNum;
    }
    public BigDecimal getInStoreAvg() {
        return inStoreAvg;
    }

    public void setInStoreAvg(BigDecimal inStoreAvg) {
        this.inStoreAvg = inStoreAvg;
    }

    public BigDecimal getHandleMny() {
        return handleMny;
    }

    public void setHandleMny(BigDecimal handleMny) {
        this.handleMny = handleMny;
    }
    public BigDecimal getInStoreTaxMny() {
        return inStoreTaxMny;
    }

    public void setInStoreTaxMny(BigDecimal inStoreTaxMny) {
        this.inStoreTaxMny = inStoreTaxMny;
    }
    public BigDecimal getInStoreTax() {
        return inStoreTax;
    }

    public void setInStoreTax(BigDecimal inStoreTax) {
        this.inStoreTax = inStoreTax;
    }
    public BigDecimal getInStoreMny() {
        return inStoreMny;
    }

    public void setInStoreMny(BigDecimal inStoreMny) {
        this.inStoreMny = inStoreMny;
    }
    public BigDecimal getHandleSubTaxMny() {
        return handleSubTaxMny;
    }

    public void setHandleSubTaxMny(BigDecimal handleSubTaxMny) {
        this.handleSubTaxMny = handleSubTaxMny;
    }
    public BigDecimal getHandleSubMny() {
        return handleSubMny;
    }

    public void setHandleSubMny(BigDecimal handleSubMny) {
        this.handleSubMny = handleSubMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getHandleTaxPrice() {
        return handleTaxPrice;
    }

    public void setHandleTaxPrice(BigDecimal handleTaxPrice) {
        this.handleTaxPrice = handleTaxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getHandleTax() {
        return handleTax;
    }

    public void setHandleTax(BigDecimal handleTax) {
        this.handleTax = handleTax;
    }
}
