/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.IAccountSettleService;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.store.vo.SurplusVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="accountSettleService")
public class AccountSettleImpl
implements IAccountSettleService {
    @Autowired
    private ISurplusService surplusService;
    @Autowired
    private IFlowService flowService;

    @Override
    public CommonResponse<String> changeAccountSettleByType(StoreApiVO storeApiVO) {
        Integer accountFlag = storeApiVO.getAccountFlag();
        Integer settleFlag = storeApiVO.getSettleFlag();
        List detail = storeApiVO.getDetail();
        if (CollectionUtils.isNotEmpty((Collection)detail)) {
            List sourceDetailIds = detail.stream().map(FlowVO::getSourceDetailId).collect(Collectors.toList());
            HashMap map = new HashMap();
            detail.forEach(t -> map.put(t.getSourceDetailId(), t));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"source_detail_Id", sourceDetailIds);
            queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
            List instoreList = this.flowService.list((Wrapper)queryWrapper);
            ArrayList<FlowEntity> updateList = new ArrayList<FlowEntity>();
            for (FlowEntity flowEntity : instoreList) {
                FlowVO flowVO = (FlowVO)map.get(flowEntity.getSourceDetailId());
                if (null == flowVO) continue;
                if (accountFlag != null) {
                    if (StoreCommonConsts.NO.equals(accountFlag)) {
                        flowEntity.setAccountFlag(StoreCommonConsts.NO);
                        flowEntity.setAccountId(null);
                        flowEntity.setAccountDetailId(null);
                        flowEntity.setAccountDate(null);
                        flowEntity.setAccountCode(null);
                    } else if (StoreCommonConsts.YES.equals(accountFlag)) {
                        flowEntity.setAccountFlag(StoreCommonConsts.YES);
                        flowEntity.setAccountId(storeApiVO.getAccountId());
                        flowEntity.setAccountDetailId(flowVO.getAccountDetailId());
                        flowEntity.setAccountDate(storeApiVO.getAccountDate());
                        flowEntity.setAccountCode(storeApiVO.getAccountCode());
                    }
                }
                if (settleFlag != null) {
                    if (StoreCommonConsts.NO.equals(settleFlag)) {
                        flowEntity.setSettleFlag(StoreCommonConsts.NO);
                        flowEntity.setSettleId(null);
                        flowEntity.setSettleDetailId(null);
                        flowEntity.setSettleDate(null);
                        flowEntity.setSettleCode(null);
                        if ("NoContract".equals(flowVO.getCusDef1())) {
                            flowEntity.setPurchaseContractId(null);
                            flowEntity.setPurchaseContractName(null);
                        }
                    } else if (StoreCommonConsts.YES.equals(settleFlag)) {
                        flowEntity.setSettleFlag(StoreCommonConsts.YES);
                        flowEntity.setSettleId(storeApiVO.getSettleId());
                        flowEntity.setSettleDetailId(flowVO.getSettleDetailId());
                        flowEntity.setSettleDate(storeApiVO.getSettleDate());
                        flowEntity.setSettleCode(storeApiVO.getSettleCode());
                        if ("NoContract".equals(flowVO.getCusDef1())) {
                            flowEntity.setPurchaseContractId(storeApiVO.getPurchaseContractId());
                            flowEntity.setPurchaseContractName(storeApiVO.getPurchaseContractName());
                        }
                    }
                }
                updateList.add(flowEntity);
            }
            this.flowService.updateBatchById(updateList);
        }
        return CommonResponse.success((String)"\u7ed3\u7b97\u5bf9\u8d26\u6210\u529f");
    }

    @Override
    public CommonResponse<StoreApiVO> settlePass(StoreApiVO storeApiVO) {
        List detail = storeApiVO.getDetail();
        if (CollectionUtils.isNotEmpty((Collection)detail)) {
            HashMap<String, SurplusVO> surplusUpdateMap = new HashMap<String, SurplusVO>();
            ArrayList<Long> storeIds = new ArrayList<Long>();
            ArrayList<Long> materialIds = new ArrayList<Long>();
            HashMap settleflowMap = new HashMap();
            detail.forEach(t -> settleflowMap.put(t.getSourceDetailId(), t));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"source_detail_Id", new ArrayList(settleflowMap.keySet()));
            queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
            List instoreList = this.flowService.list((Wrapper)queryWrapper);
            HashMap<Long, FlowEntity> flowMap = new HashMap<Long, FlowEntity>();
            for (FlowEntity t2 : instoreList) {
                if (ComputeUtil.isNotEmpty((BigDecimal)t2.getOutLockNum()).booleanValue()) {
                    return CommonResponse.error((String)("\u7269\u8d44[\u540d\u79f0:" + t2.getMaterialName() + ",\u89c4\u683c:" + StrUtil.emptyToDefault((CharSequence)t2.getMaterialSpec(), (String)"\u65e0") + "]\u5df2\u88ab\u81ea\u7531\u6001\u51fa\u5e93\u5355\u5360\u7528\u4e2d,\u4e0d\u5141\u8bb8\u7ed3\u7b97!"), (Object)storeApiVO);
                }
                Long storeId = t2.getStoreId();
                Long materialId = t2.getMaterialId();
                Long sourceDetailId = t2.getSourceDetailId();
                BigDecimal surplusMnyOld = t2.getSurplusMny();
                BigDecimal surplusTaxMnyOld = t2.getSurplusTaxMny();
                FlowVO settleFlow = (FlowVO)settleflowMap.get(sourceDetailId);
                if (settleFlow == null || ComputeUtil.equals((BigDecimal)t2.getTaxPrice(), (BigDecimal)settleFlow.getSettleTaxPrice())) continue;
                settleFlow.setOutNum(t2.getOutNum());
                settleFlow.setPrice(t2.getPrice());
                settleFlow.setTaxPrice(t2.getTaxPrice());
                storeIds.add(storeId);
                materialIds.add(materialId);
                String storeKey = String.valueOf(storeId) + materialId;
                SurplusVO surplusUpdateVO = (SurplusVO)surplusUpdateMap.get(storeKey);
                if (surplusUpdateVO == null) {
                    surplusUpdateVO = new SurplusVO();
                    surplusUpdateVO.setStoreId(storeId);
                    surplusUpdateVO.setMaterialId(materialId);
                }
                t2.setPrice(settleFlow.getSettlePrice());
                t2.setTaxPrice(settleFlow.getSettleTaxPrice());
                BigDecimal surplusMnyNew = ComputeUtil.safeMultiply((BigDecimal)t2.getSurplusNum(), (BigDecimal)t2.getPrice());
                BigDecimal surplusTaxMnyNew = ComputeUtil.safeMultiply((BigDecimal)t2.getSurplusNum(), (BigDecimal)t2.getTaxPrice());
                t2.setSurplusMny(surplusMnyNew);
                t2.setSurplusTaxMny(surplusTaxMnyNew);
                BigDecimal surplusMnyDiff = ComputeUtil.safeSub((BigDecimal)surplusMnyNew, (BigDecimal)surplusMnyOld);
                BigDecimal surplusTaxMnyDiff = ComputeUtil.safeSub((BigDecimal)surplusTaxMnyNew, (BigDecimal)surplusTaxMnyOld);
                surplusUpdateVO.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)surplusUpdateVO.getSurplusMny(), (BigDecimal)surplusMnyDiff));
                surplusUpdateVO.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusUpdateVO.getSurplusTaxMny(), (BigDecimal)surplusTaxMnyDiff));
                surplusUpdateMap.put(storeKey, surplusUpdateVO);
                settleFlow.setDiffMny(ComputeUtil.safeSub((BigDecimal)settleFlow.getSettleMny(), (BigDecimal)t2.getMny()));
                settleFlow.setDiffTaxMny(ComputeUtil.safeSub((BigDecimal)settleFlow.getSettleTaxMny(), (BigDecimal)t2.getTaxMny()));
                settleFlow.setDiffTax(ComputeUtil.safeSub((BigDecimal)settleFlow.getDiffTaxMny(), (BigDecimal)settleFlow.getDiffMny()));
                BigDecimal diffPrice = ComputeUtil.safeSub((BigDecimal)settleFlow.getSettlePrice(), (BigDecimal)settleFlow.getPrice());
                BigDecimal diffTaxPrice = ComputeUtil.safeSub((BigDecimal)settleFlow.getSettleTaxPrice(), (BigDecimal)settleFlow.getTaxPrice());
                settleFlow.setCostMny(ComputeUtil.safeMultiply((BigDecimal)settleFlow.getOutNum(), (BigDecimal)diffPrice));
                settleFlow.setCostTaxMny(ComputeUtil.safeMultiply((BigDecimal)settleFlow.getOutNum(), (BigDecimal)diffTaxPrice));
                settleFlow.setCostTax(ComputeUtil.safeSub((BigDecimal)settleFlow.getCostTaxMny(), (BigDecimal)settleFlow.getCostMny()));
                flowMap.put(sourceDetailId, t2);
            }
            if (CollectionUtils.isNotEmpty(storeIds) && CollectionUtils.isNotEmpty(materialIds)) {
                QueryWrapper surplusEntityQueryWrapper = new QueryWrapper();
                surplusEntityQueryWrapper.in((Object)"store_id", storeIds);
                surplusEntityQueryWrapper.in((Object)"material_id", materialIds);
                List list = this.surplusService.list((Wrapper)surplusEntityQueryWrapper);
                list.forEach(t -> {
                    String storeKey = String.valueOf(t.getStoreId()) + t.getMaterialId();
                    SurplusVO surplusVO = (SurplusVO)surplusUpdateMap.get(storeKey);
                    if (null != surplusVO) {
                        t.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusMny(), (BigDecimal)surplusVO.getSurplusMny()));
                        t.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusTaxMny(), (BigDecimal)surplusVO.getSurplusTaxMny()));
                    }
                });
                this.surplusService.saveOrUpdateBatch(list);
                this.flowService.saveOrUpdateBatch(new ArrayList(flowMap.values()));
                storeApiVO.setDetail(new ArrayList(settleflowMap.values()));
            }
        }
        return CommonResponse.success((Object)storeApiVO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<StoreApiVO> settleRollback(StoreApiVO storeApiVO) {
        List detail = storeApiVO.getDetail();
        Long settleId = storeApiVO.getSettleId();
        HashMap<String, SurplusVO> surplusUpdateMap = new HashMap<String, SurplusVO>();
        ArrayList<Long> storeIds = new ArrayList<Long>();
        ArrayList<Long> materialIds = new ArrayList<Long>();
        if (settleId == null) return CommonResponse.error((String)"\u7ed3\u7b97\u5355id\u4e3a\u7a7a");
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"settle_id", (Object)settleId);
        List flowEntityList = this.flowService.list((Wrapper)objectQueryWrapper);
        if (!CollectionUtils.isNotEmpty((Collection)flowEntityList)) return CommonResponse.success((Object)storeApiVO);
        List ids = flowEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ids", ids);
        Integer count = this.flowService.settleCount(map);
        if (!count.equals(StoreCommonConsts.ZERO)) return CommonResponse.error((String)"\u5df2\u5b58\u5728\u51fa\u5e93\u5355\u4f7f\u7528\u6b64\u7ed3\u7b97\u5355\u4ef7\u51fa\u5e93\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        List list = BeanMapper.mapList((Iterable)flowEntityList, FlowVO.class);
        for (FlowVO flowVO : list) {
            BigDecimal surplusMnyNew = ComputeUtil.safeMultiply((BigDecimal)flowVO.getSurplusNum(), (BigDecimal)flowVO.getEstimatePrice());
            BigDecimal surplusTaxMnyNew = ComputeUtil.safeMultiply((BigDecimal)flowVO.getSurplusNum(), (BigDecimal)flowVO.getEstimatePrice());
            flowVO.setSurplusMny(surplusMnyNew);
            flowVO.setSurplusTaxMny(surplusTaxMnyNew);
            Long storeId = flowVO.getStoreId();
            Long materialId = flowVO.getMaterialId();
            storeIds.add(flowVO.getStoreId());
            materialIds.add(flowVO.getMaterialId());
            String storeKey = String.valueOf(storeId) + materialId;
            SurplusVO surplusUpdateVO = (SurplusVO)surplusUpdateMap.get(storeKey);
            if (surplusUpdateVO == null) {
                surplusUpdateVO = new SurplusVO();
                surplusUpdateVO.setStoreId(storeId);
                surplusUpdateVO.setMaterialId(materialId);
            }
            BigDecimal surplusMnyOld = ComputeUtil.safeMultiply((BigDecimal)flowVO.getSurplusNum(), (BigDecimal)flowVO.getPrice());
            BigDecimal surplusTaxMnyOld = ComputeUtil.safeMultiply((BigDecimal)flowVO.getSurplusNum(), (BigDecimal)flowVO.getTaxPrice());
            BigDecimal surplusMnyDiff = ComputeUtil.safeSub((BigDecimal)surplusMnyNew, (BigDecimal)surplusMnyOld);
            BigDecimal surplusTaxMnyDiff = ComputeUtil.safeSub((BigDecimal)surplusTaxMnyNew, (BigDecimal)surplusTaxMnyOld);
            flowVO.setTaxPrice(flowVO.getEstimateTaxPrice());
            flowVO.setPrice(flowVO.getEstimatePrice());
            surplusUpdateVO.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)surplusUpdateVO.getSurplusMny(), (BigDecimal)surplusMnyDiff));
            surplusUpdateVO.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusUpdateVO.getSurplusTaxMny(), (BigDecimal)surplusTaxMnyDiff));
            surplusUpdateMap.put(storeKey, surplusUpdateVO);
        }
        if (!CollectionUtils.isNotEmpty(storeIds) || !CollectionUtils.isNotEmpty(materialIds)) return CommonResponse.success((Object)storeApiVO);
        QueryWrapper surplusEntityQueryWrapper = new QueryWrapper();
        surplusEntityQueryWrapper.in((Object)"store_id", storeIds);
        surplusEntityQueryWrapper.in((Object)"material_id", materialIds);
        List surplusEntityList = this.surplusService.list((Wrapper)surplusEntityQueryWrapper);
        surplusEntityList.forEach(t -> {
            String storeKey = String.valueOf(t.getStoreId()) + t.getMaterialId();
            SurplusVO surplusVO = (SurplusVO)surplusUpdateMap.get(storeKey);
            if (null != surplusVO) {
                t.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusMny(), (BigDecimal)surplusVO.getSurplusMny()));
                t.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusTaxMny(), (BigDecimal)surplusVO.getSurplusTaxMny()));
            }
        });
        List updateFlowList = BeanMapper.mapList((Iterable)list, FlowEntity.class);
        this.flowService.saveOrUpdateBatch(updateFlowList);
        this.surplusService.saveOrUpdateBatch(surplusEntityList);
        storeApiVO.setDetail(list);
        return CommonResponse.success((Object)storeApiVO);
    }

    @Override
    public CommonResponse<String> changeSettleFlag(StoreApiVO storeApiVO) {
        Integer settleFlag = storeApiVO.getSettleFlag();
        List detail = storeApiVO.getDetail();
        if (CollectionUtils.isNotEmpty((Collection)detail)) {
            for (FlowVO flowVO : detail) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourceDetailId", flowVO.getSourceDetailId());
                if (settleFlag != null) {
                    if (StoreCommonConsts.NO.equals(settleFlag)) {
                        map.put("settleFlag", StoreCommonConsts.NO);
                        map.put("settleId", null);
                        map.put("settleDetailId", null);
                        map.put("settleDate", null);
                        map.put("settleCode", null);
                    } else if (StoreCommonConsts.YES.equals(settleFlag)) {
                        map.put("settleFlag", StoreCommonConsts.YES);
                        map.put("settleId", storeApiVO.getSettleId());
                        map.put("settleDetailId", flowVO.getSettleDetailId());
                        map.put("settleDate", storeApiVO.getSettleDate());
                        map.put("settleCode", storeApiVO.getSettleCode());
                    }
                }
                this.flowService.changeSettleFlag(map);
            }
        }
        return CommonResponse.success((String)"\u7ed3\u7b97\u6210\u529f");
    }

    public static void main(String[] args) {
        System.out.println("1".equals(null));
    }
}

