package com.ejianc.business.store.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 调拨入库
 *
 * @author generator
 *
 */
 @TableName("ejc_store_project_allot")
public class ProjAllotEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 出库项目id
    @TableField(value="project_name")
    private String projectName; // 入库项目名称
    @TableField(value="org_id")
    private Long orgId; // 入库组织id
    @TableField(value="org_name")
    private String orgName; // 入库组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="in_store_id")
    private Long inStoreId; // 调入仓库id
    @TableField(value="in_store_name")
    private String inStoreName; // 调入仓库名称
    @TableField(value="out_date")
    private Date outDate; // 调出的时间
    @TableField(value="out_mny")
    private BigDecimal outMny; // 调出金额
    @TableField(value="out_tax_mny")
    private BigDecimal outTaxMny; // 调出金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; //  经办人部门
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="out_store_id")
    private Long outStoreId; // 出库id
    @TableField(value="out_store_name")
    private String outStoreName; // 出库名称
    @TableField(value="out_manage_type")
    private Integer outManageType; // 管理属性 1-分包仓库 2-项目仓库；
    @TableField(value="in_manage_type")
    private Integer inManageType; // 管理属性 1-分包仓库 2-项目仓库；

    @TableField(exist=false)
    @SubEntity(serviceName="projAllotDetailService",pidName ="allotId")
    private List<ProjAllotDetailEntity> detailList = new ArrayList<>(); // 调拨入库子表


    @TableField(value="org_code")
    private String orgCode; // 项目组织编码

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getInStoreId() {
        return inStoreId;
    }

    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }

    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }

    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }

    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getOutStoreId() {
        return outStoreId;
    }

    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }

    public String getOutStoreName() {
        return outStoreName;
    }

    public void setOutStoreName(String outStoreName) {
        this.outStoreName = outStoreName;
    }

    public Integer getOutManageType() {
        return outManageType;
    }

    public void setOutManageType(Integer outManageType) {
        this.outManageType = outManageType;
    }

    public Integer getInManageType() {
        return inManageType;
    }

    public void setInManageType(Integer inManageType) {
        this.inManageType = inManageType;
    }

    public List<ProjAllotDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ProjAllotDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
}
