package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.store.bean.InitialCheckDetailEntity;
import com.ejianc.business.store.bean.InitialCheckEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.service.IInitialCheckService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("initialCheck") 
public class InitialCheckBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IInitialCheckService initialCheckService;
	@Autowired
	StoreManageService storeManageService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		InitialCheckEntity checkEntity = initialCheckService.selectById(billId);
		//调用库存逻辑
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.收料入库);
		storeManageVO.setStoreId(checkEntity.getStoreId());
		storeManageVO.setOutEffectiveON(true);
		storeManageVO.setSourceId(checkEntity.getId());
		ArrayList<FlowVO> flowVOS = new ArrayList<>();
//			checkEntity.getCheckDetailList().forEach(t->{
//				FlowVO flowVO = new FlowVO();
//				if (checkEntity.getCheckType().equals("proMaterial-2")) {
//					flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材收料入库, 0);
//				}
//				if (!checkEntity.getCheckType().equals("proMaterial-2")) {
//					flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.收料入库, 0);
//				}
//
//				getFlow(checkEntity, t, flowVO);
//				flowVOS.add(flowVO);
//			});
		for(int i=0;i<checkEntity.getInitialCheckDetailList().size();i++){
			FlowVO flowVO = new FlowVO();
			flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.收料入库, 0);

			getFlow(checkEntity, checkEntity.getInitialCheckDetailList().get(i), flowVO);
			flowVOS.add(flowVO);
		}

		storeManageVO.setFlowVOList(flowVOS);
		String stringInfo = JSONObject.toJSONString(storeManageVO);
		logger.info("消耗材验收入库参数：" +stringInfo);
		CommonResponse<StoreManageVO> response = storeManageService.inOutStore(storeManageVO);
		if(!response.isSuccess()) {
			logger.info("测试报错01");
			throw new BusinessException("调用库存管理失败,错误信息" +response.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		InitialCheckEntity checkEntity = initialCheckService.selectById(billId);
		List<Long> ids = new ArrayList<>();
		ids.add(billId);
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setSourceId(checkEntity.getId());
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.收料入库);
		storeManageVO.setStoreId(checkEntity.getStoreId());
		storeManageVO.setOutEffectiveON(true);
		String stringInfo = JSONObject.toJSONString(storeManageVO);
		logger.info("期初盘点撤回参数：" +stringInfo);
		CommonResponse<StoreManageVO> response = storeManageService.inOutStoreRollback(storeManageVO);
		if(!response.isSuccess()) {
			return CommonResponse.error(response.getMsg());
		}else{
			logger.info("xhc推送仓库成功:"+response.getMsg());
		}
		return CommonResponse.success();
	}

	private void getFlow(InitialCheckEntity checkEntity, InitialCheckDetailEntity t, FlowVO flowVO) {
		flowVO.setProjectId(checkEntity.getProjectId());
		flowVO.setTaxRate(t.getTaxRate());
		flowVO.setProjectName(checkEntity.getProjectName());
		flowVO.setParentOrgId(checkEntity.getParentOrgId());
		flowVO.setParentOrgName(checkEntity.getParentOrgName());
		flowVO.setOrgId(checkEntity.getOrgId());
		flowVO.setOrgName(checkEntity.getOrgName());
		flowVO.setStoreId(checkEntity.getStoreId());
		flowVO.setStoreName(checkEntity.getStoreName());
		flowVO.setEmployeeId(checkEntity.getEmployeeId());
		flowVO.setEmployeeName(checkEntity.getEmployeeName());
//		flowVO.setMaterialType(checkEntity.getCheckType());
//		flowVO.setMaterialTypeName(checkEntity.getCheckTypeName());
//		flowVO.setSupplierId(checkEntity.getSupplierId());
//		flowVO.setSupplierName(checkEntity.getSupplierName());
//		flowVO.setPurchaseContractId(checkEntity.getContractId());
//		flowVO.setPurchaseContractName(checkEntity.getContractName());
		flowVO.setMaterialCategoryId(t.getMaterialTypeId());
		flowVO.setMaterialCategoryName(t.getMaterialTypeName());
		flowVO.setMaterialId(t.getMaterialId());
		flowVO.setMaterialName(t.getMaterialName());
		flowVO.setMaterialCode(t.getMaterialCode());
		flowVO.setMaterialSpec(t.getSpec());
		flowVO.setMaterialUnitId(t.getUnitId());
		flowVO.setMaterialUnitName(t.getUnit());
		flowVO.setTaxPrice(t.getCheckTaxPrice());
		flowVO.setPrice(t.getCheckPrice());
		flowVO.setNum(t.getCheckNum());
		flowVO.setTaxMny(t.getCheckTaxMny());
		flowVO.setMny(t.getCheckMny());
		flowVO.setTax(t.getTaxMny());
//		flowVO.setPickUnitId(checkEntity.getSubSupplierId());
//		flowVO.setPickUnitName(checkEntity.getSubSupplierName());
//		flowVO.setPickContractId(checkEntity.getSubContractId());
//		flowVO.setPickContractName(checkEntity.getSubContractName());
		flowVO.setSourceId(checkEntity.getId());
		flowVO.setSourceDetailId(t.getId());
		flowVO.setSourceBillCode(checkEntity.getBillCode());
		flowVO.setSourceBillDate(checkEntity.getCheckDate());
		flowVO.setSourceBillRemark(checkEntity.getMemo());
		flowVO.setSourceBillDetailRemark(t.getMemo());
		flowVO.setSourceBillTypeName("期初盘点");
		flowVO.setSourceBillTypeCode("BT202408000001");
		flowVO.setSourceType(0);
//		flowVO.setPickType(checkEntity.getSubOutType());
//		flowVO.setLicensePlate(checkEntity.getLicensePlate());
		//1-内部领料,2-分包领料
//		if (checkEntity.getSubOutType() != null && checkEntity.getSubOutType() == 1){
//			flowVO.setPickTypeName("内部领料");
//		}
//		if (checkEntity.getSubOutType() != null && checkEntity.getSubOutType() == 2){
//			flowVO.setPickTypeName("分包领料");
//		}
		flowVO.setRowState(t.getRowState());
	}

}
