package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.store.bean.ProjAllotEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.mapper.ProjAllotMapper;
import com.ejianc.business.store.service.IProjAllotService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.ProjAllotVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 调拨入库
 *
 * @author generator
 */
@Service("projAllotService")
public class ProjAllotServiceImpl extends BaseServiceImpl<ProjAllotMapper, ProjAllotEntity> implements IProjAllotService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "PROJ_ALLOT";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    StoreManageService storeManageService;
    @Override
    public ProjAllotVO saveOrUpdate(ProjAllotVO saveOrUpdateVO) {
        if (null != saveOrUpdateVO.getOutStoreId() && null != saveOrUpdateVO.getInStoreId() && saveOrUpdateVO.getOutStoreId() == saveOrUpdateVO.getInStoreId()) {
            throw new BusinessException("调出与调入不能为同一仓库！");
        }
        ProjAllotEntity entity = BeanMapper.map(saveOrUpdateVO, ProjAllotEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdate(entity, false);
        ProjAllotVO vo = BeanMapper.map(entity, ProjAllotVO.class);
        if (CollectionUtils.isNotEmpty(vo.getDetailList())) {
            StoreManageVO storeManageVO = getStoreManageVO(vo, InOutTypeEnum.调拨出库, false);
            storeManageService.inOutStore(storeManageVO);
        }
        return vo;
    }

    @Override
    public void delete(List<ProjAllotVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjAllotVO vo : vos) {
                ProjAllotEntity allotOutEntity = selectById(vo.getId());
                if (CollectionUtils.isNotEmpty(allotOutEntity.getDetailList())){
                    StoreManageVO storeManageVO = new StoreManageVO();
                    storeManageVO.setSourceId(vo.getId());
                    storeManageVO.setStoreId(vo.getOutStoreId());
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨出库);
                    storeManageVO.setOutEffectiveON(false);
                    ArrayList<Long> longs = new ArrayList<>();
                    longs.add(vo.getId());
                    storeManageVO.setSourceIdsForRollBack(longs);
                    logger.info("调用库存参数：————" + JSONObject.toJSONString(storeManageVO));
                    storeManageService.inOutStoreRollback(storeManageVO);
                }
            }
        }
        removeByIds(vos.stream().map(ProjAllotVO::getId).collect(Collectors.toList()),true);
    }

    @Override
    public StoreManageVO getStoreManageVO(ProjAllotVO vo, InOutTypeEnum inOutTypeEnum, boolean outEffective){
        StoreManageVO storeManageVO = new StoreManageVO();
        if (vo!=null){
            storeManageVO.setStoreId(2 == inOutTypeEnum.getInOutFlag() ? vo.getOutStoreId() : vo.getInStoreId());
            storeManageVO.setSourceId(vo.getId());
            storeManageVO.setInOutTypeEnum(inOutTypeEnum);
            storeManageVO.setOutEffectiveON(outEffective);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            vo.getDetailList().forEach(t->{
                FlowVO flowVO = StoreManageUtil.getFlowVO(inOutTypeEnum, 0);
                flowVO.setStoreId(vo.getOutStoreId());
                flowVO.setStoreName(vo.getOutStoreName());
                flowVO.setSourceBillTypeName("同项目调拨");
                flowVO.setSourceBillTypeCode("BT202412000002");
                flowVO.setProjectId(vo.getProjectId());
                flowVO.setProjectName(vo.getProjectName());
                flowVO.setOrgId(vo.getOrgId());
                flowVO.setOrgName(vo.getOrgName());
                flowVO.setParentOrgId(vo.getParentOrgId());
                flowVO.setParentOrgName(vo.getParentOrgName());
                flowVO.setParentOrgCode(vo.getParentOrgCode());
                flowVO.setEmployeeId(vo.getEmployeeId());
                flowVO.setEmployeeName(vo.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getMaterialSpec());
                flowVO.setMaterialUnitId(t.getMaterialUnitId());
                flowVO.setMaterialUnitName(t.getMaterialUnit());
                flowVO.setNum(t.getAllotNum());
                flowVO.setTaxPrice(t.getSurplusTaxPrice());
                flowVO.setPrice(t.getSurplusPrice());
                flowVO.setTaxMny(t.getAllotTaxMny());
                flowVO.setMny(t.getAllotMny());
                flowVO.setTax(ComputeUtil.safeSub(flowVO.getTaxMny(), flowVO.getMny()));
                flowVO.setTaxRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(flowVO.getTax(), flowVO.getMny()), BigDecimal.valueOf(100)));
                flowVO.setSourceId(vo.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(vo.getBillCode());
                flowVO.setSourceBillDate(vo.getOutDate());
                flowVO.setSourceBillRemark(vo.getMemo());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
        }
        return storeManageVO;
    }
}
