/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service;

import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.IInOutService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.service.handler.IStoreManageHandler;
import com.ejianc.business.store.service.handler.StoreManageFactory;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.SurplusUpdateVO;
import com.ejianc.business.store.vo.UseCalculateVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreManageService {
    @Autowired
    private StoreManageFactory storeManageFactory;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IInOutService inOutService;
    @Autowired
    IFlowService flowService;
    @Autowired
    IShareMaterialApi shareMaterialApi;

    public CommonResponse<StoreManageVO> inOutStore(StoreManageVO storeManageVO) {
        this.fullMaterialInfo(storeManageVO);
        CommonResponse<StoreManageVO> validateRes = this.validateParam(storeManageVO, false);
        if (!validateRes.isSuccess()) {
            return validateRes;
        }
        InOutTypeEnum inOutTypeEnum = storeManageVO.getInOutTypeEnum();
        IStoreManageHandler storeManageHandler = this.storeManageFactory.getHandler(inOutTypeEnum);
        CommonResponse<StoreManageVO> handle = storeManageHandler.handle(storeManageVO);
        return handle;
    }

    private void fullMaterialInfo(StoreManageVO storeManageVO) {
        if (CollectionUtils.isNotEmpty((Collection)storeManageVO.getFlowVOList())) {
            List flowVOList = storeManageVO.getFlowVOList();
            HashSet<Long> matIdSet = new HashSet<Long>();
            for (FlowVO flowVO : flowVOList) {
                if (!StringUtils.isBlank((CharSequence)flowVO.getMaterialCode()) && !StringUtils.isBlank((CharSequence)flowVO.getMaterialName())) continue;
                matIdSet.add(flowVO.getMaterialId());
            }
            if (!matIdSet.isEmpty()) {
                Map matMap = ((List)this.shareMaterialApi.queryMaterialByIds(new ArrayList(matIdSet)).getData()).stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity(), (k1, k2) -> k1));
                for (FlowVO flowVO : storeManageVO.getFlowVOList()) {
                    if (StringUtils.isBlank((CharSequence)flowVO.getMaterialCode())) {
                        flowVO.setMaterialCode(((MaterialVO)matMap.get(flowVO.getMaterialId())).getCode());
                    }
                    if (!StringUtils.isBlank((CharSequence)flowVO.getMaterialName())) continue;
                    flowVO.setMaterialName(((MaterialVO)matMap.get(flowVO.getMaterialId())).getName());
                }
            }
        }
    }

    public CommonResponse<StoreManageVO> inOutStoreRollback(StoreManageVO storeManageVO) {
        CommonResponse<StoreManageVO> validateRes = this.validateParam(storeManageVO, true);
        if (!validateRes.isSuccess()) {
            return validateRes;
        }
        InOutTypeEnum inOutTypeEnum = storeManageVO.getInOutTypeEnum();
        IStoreManageHandler storeManageHandler = this.storeManageFactory.getHandler(inOutTypeEnum);
        CommonResponse<StoreManageVO> handle = storeManageHandler.handleRollback(storeManageVO);
        return handle;
    }

    public CommonResponse<StoreManageVO> surplusMaterialPrice(StoreManageVO storeManageVO) {
        CommonResponse<SurplusUpdateVO> response = this.surplusService.validateStoreSurplusByOutLock(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        UseCalculateVO useCalculateVO = this.surplusService.useCalculate(storeManageVO);
        storeManageVO.setUseMaterialPriceVOList(useCalculateVO.getUseMaterialPriceVOList());
        return CommonResponse.success((Object)storeManageVO);
    }

    public CommonResponse<StoreManageVO> updateShareMny(StoreManageVO storeManageVO) {
        storeManageVO = this.flowService.updateShareMny(storeManageVO);
        return CommonResponse.success((Object)storeManageVO);
    }

    private CommonResponse<StoreManageVO> validateParam(StoreManageVO storeManageVO, boolean isRollBack) {
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        InOutTypeEnum inOutTypeEnum = storeManageVO.getInOutTypeEnum();
        List sourceIdsForRollBack = storeManageVO.getSourceIdsForRollBack();
        if (storeId == null) {
            return CommonResponse.error((String)"\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (CollectionUtils.isEmpty((Collection)sourceIdsForRollBack) && sourceId == null) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5355\u636e\u4e3b\u8868ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (inOutTypeEnum == null) {
            return CommonResponse.error((String)"\u51fa\u5165\u5e93\u679a\u4e3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<StoreManageVO> turnSurplusMaterialPrice(StoreManageVO storeManageVO) {
        CommonResponse<SurplusUpdateVO> response = this.surplusService.validateStoreSurplusByOutLock(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        UseCalculateVO useCalculateVO = this.surplusService.useTurnCalculate(storeManageVO);
        storeManageVO.setUseMaterialPriceVOList(useCalculateVO.getUseMaterialPriceVOList());
        return CommonResponse.success((Object)storeManageVO);
    }
}

