/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.store.bean.CheckDetailEntity;
import com.ejianc.business.store.bean.CheckEntity;
import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.store.vo.CheckDetailVO;
import com.ejianc.business.store.vo.CheckVO;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"check"})
public class CheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFlowService flowService;
    @Autowired
    private ICheckSupplierApi checkSupplierApi;
    private static final String BILL_CODE = "STORE_CHECK_CODE";
    @Autowired
    private ICheckService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CheckBpmServiceImpl check;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveOrUpdateVO) {
        CheckVO checkVO = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)checkVO);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> pushCost(@RequestBody CheckVO checkVO) {
        return this.service.pushCost(checkVO);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody CheckVO checkVO) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.checkParams(checkVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.service.selectById(id));
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/querySubDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CheckDetailVO>> querySubDetail(@RequestParam(value="materialIds") List<Long> materialIds, @RequestParam(value="projectId", required=false) Long projectId, @RequestParam(value="storeId") Long storeId, @RequestParam(value="sourceBillDate") String sourceBillDate) {
        List<CheckDetailVO> detailVOList = this.service.querySubDetail(materialIds, projectId, storeId, sourceBillDate);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", detailVOList);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CheckVO vo : vos) {
                CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(vo.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
                if (stringCommonResponse.isSuccess()) continue;
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        this.service.myRemoveByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/checkByDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse checkByDate(Long storeId, String checkDate) {
        return this.service.checkByDate(storeId, checkDate);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "orgName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "orgName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
        }
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        List list = this.service.queryList(param);
        List checkVOVos = BeanMapper.mapList((Iterable)list, CheckVO.class);
        checkVOVos.forEach(item -> item.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", checkVOVos);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }

    @PostMapping(value={"excelExportMaterialList"})
    public void excelExportMaterialList(@RequestBody CheckVO checkVO, HttpServletResponse response) {
        CheckEntity entity = (CheckEntity)((Object)this.service.selectById(checkVO.getId()));
        DecimalFormat df = new DecimalFormat("#,##0.00");
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List<CheckDetailEntity> data = entity.getCheckSubList();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                CheckDetailVO vo = (CheckDetailVO)BeanMapper.map((Object)item, CheckDetailVO.class);
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("checkDetailExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"projectId")) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("useFlag", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getNewPrice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FlowVO> getNewPrice(Long storeId, Long materialId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"store_id", (Object)storeId);
        wrapper.eq((Object)"material_id", (Object)materialId);
        wrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
        wrapper.orderByDesc((Object)"source_bill_date");
        wrapper.last("limit 0,1");
        FlowEntity flowEntity = (FlowEntity)((Object)this.flowService.list((Wrapper)wrapper).get(0));
        FlowVO vo = (FlowVO)BeanMapper.map((Object)((Object)flowEntity), FlowVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckSupplierDTO> test(Long id) {
        CommonResponse checkSupplierDTOCommonResponse = this.checkSupplierApi.queryCheckDTO(id);
        return checkSupplierDTOCommonResponse;
    }
}

