/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.store.bean.CheckDetailEntity;
import com.ejianc.business.store.bean.PdallDetailEntity;
import com.ejianc.business.store.bean.PdallEntity;
import com.ejianc.business.store.service.ICheckDetailService;
import com.ejianc.business.store.service.IPdallService;
import com.ejianc.business.store.vo.PdallVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"pdall"})
public class PdallController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPdallService service;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PdallVO> saveOrUpdate(@RequestBody PdallVO saveOrUpdateVO) {
        PdallVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PdallVO> queryDetail(Long id) {
        PdallEntity entity = (PdallEntity)((Object)this.service.selectById(id));
        PdallVO vo = (PdallVO)BeanMapper.map((Object)((Object)entity), PdallVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getListById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PdallDetailEntity>> getListById(@RequestBody List<Long> checkIds) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(CheckDetailEntity::getCheckId, checkIds);
        List checkDetailEntities = this.checkDetailService.list((Wrapper)lambdaQueryWrapper);
        ArrayList pdallDetailEntities = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)checkDetailEntities)) {
            Map<Long, List<CheckDetailEntity>> map = checkDetailEntities.stream().collect(Collectors.groupingBy(s -> s.getMaterialCategoryId()));
            map.forEach((key, value) -> {
                PdallDetailEntity pdallDetailEntity = new PdallDetailEntity();
                CheckDetailEntity checkDetailEntity = (CheckDetailEntity)((Object)((Object)value.stream().findFirst().get()));
                pdallDetailEntity.setMaterialCategoryId(checkDetailEntity.getMaterialCategoryId());
                pdallDetailEntity.setMaterialCategoryName(checkDetailEntity.getMaterialCategoryName());
                pdallDetailEntity.setMaterialCategoryCode(checkDetailEntity.getCategoryCode());
                BigDecimal beginMny = value.stream().map(CheckDetailEntity::getBeginMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setBeginMny(beginMny);
                BigDecimal inMny = value.stream().map(CheckDetailEntity::getInMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setInMny(inMny);
                BigDecimal inStoreMny = value.stream().map(CheckDetailEntity::getInStoreMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setInStoreMny(inStoreMny);
                BigDecimal outStoreMny = value.stream().map(CheckDetailEntity::getOutStoreMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setOutStoreMny(outStoreMny);
                BigDecimal outMny = value.stream().map(CheckDetailEntity::getOutMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setOutMny(outMny);
                BigDecimal accAmount = value.stream().map(CheckDetailEntity::getAccAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setAccAmount(accAmount);
                BigDecimal checkMny = value.stream().map(CheckDetailEntity::getCheckMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setCheckMny(checkMny);
                BigDecimal inventory = value.stream().map(CheckDetailEntity::getInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setInventory(inventory);
                pdallDetailEntities.add(pdallDetailEntity);
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", pdallDetailEntities);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PdallVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PdallVO pdallVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.service.deleteCheckId(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PdallVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        Object orgVOList = null;
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PdallVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List checkVOs = BeanMapper.mapList((Iterable)list, PdallVO.class);
        checkVOs.forEach(item -> item.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Pdall-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPdallData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PdallVO>> refPdallData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"projectId")) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PdallVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

