/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.OutFlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/storeManage/"})
@Api(value="\u4ed3\u5e93\u7ba1\u7406\u516c\u5171API\u63a5\u53e3", tags={"\u4ed3\u5e93\u7ba1\u7406\u516c\u5171API\u63a5\u53e3"})
public class StoreManageApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    StoreManageService storeManageService;
    @Autowired
    IFlowService flowService;

    @ApiOperation(value="\u51fa\u5165\u5e93\u6b63\u5411\u64cd\u4f5c")
    @RequestMapping(value={"/inOutStore"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<StoreManageVO> inOutStore(@RequestBody StoreManageVO storeManageVO) {
        return this.storeManageService.inOutStore(storeManageVO);
    }

    @ApiOperation(value="\u51fa\u5165\u5e93\u9006\u5411\u64cd\u4f5c")
    @RequestMapping(value={"/inOutStoreRollback"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<StoreManageVO> inOutStoreRollback(@RequestBody StoreManageVO storeManageVO) {
        return this.storeManageService.inOutStoreRollback(storeManageVO);
    }

    @ApiOperation(value="\u73b0\u5b58\u91cf\u5e93\u5b58\u5747\u4ef7")
    @RequestMapping(value={"/surplusMaterialPrice"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<StoreManageVO> surplusMaterialPrice(@RequestBody StoreManageVO storeManageVO) {
        return this.storeManageService.surplusMaterialPrice(storeManageVO);
    }

    @ApiOperation(value="\u66f4\u65b0\u644a\u9500\u91d1\u989d")
    @RequestMapping(value={"/updateShareMny"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<StoreManageVO> updateShareMny(@RequestBody StoreManageVO storeManageVO) {
        return this.storeManageService.updateShareMny(storeManageVO);
    }

    @ApiOperation(value="\u5468\u8f6c\u6750\u5e93\u5b58\u73b0\u5b58\u91cf\u5e93\u5b58\u5747\u4ef7")
    @RequestMapping(value={"/turnSurplusMaterialPrice"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<StoreManageVO> turnSurplusMaterialPrice(@RequestBody StoreManageVO storeManageVO) {
        return this.storeManageService.turnSurplusMaterialPrice(storeManageVO);
    }

    @PostMapping(value={"getFlowListByContractId"})
    @ResponseBody
    CommonResponse<List<FlowVO>> getFlowListByContractId(@RequestBody OutFlowVO outFlowVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("inOutType", new Parameter("in", (Object)outFlowVO.getInOutTypeList()));
        param.getParams().put("pickContractId", new Parameter("eq", (Object)outFlowVO.getContractId()));
        param.getParams().put("effectiveState", new Parameter("eq", (Object)StoreCommonConsts.YES));
        param.getParams().put("settleFlag", new Parameter("eq", (Object)StoreCommonConsts.NO));
        List flowEntities = this.flowService.queryList(param, false);
        List list = BeanMapper.mapList((Iterable)flowEntities, FlowVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)list);
    }

    @PostMapping(value={"/queryInstoreTaxMnyByPurchaseContractId"})
    @ResponseBody
    CommonResponse<BigDecimal> queryInstoreTaxMnyByPurchaseContractId(@RequestBody OutFlowVO outFlowVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(SUM(tax_mny),0) as taxMny"});
        queryWrapper.eq((Object)"purchase_contract_id", (Object)outFlowVO.getContractId());
        queryWrapper.eq((Object)"in_out_flag", (Object)1);
        if (null != outFlowVO.getPartyaFlag()) {
            queryWrapper.eq((Object)"partya_flag", (Object)outFlowVO.getPartyaFlag());
        }
        if (CollectionUtils.isNotEmpty((Collection)outFlowVO.getInOutTypeList())) {
            queryWrapper.in(CollectionUtils.isNotEmpty((Collection)outFlowVO.getInOutTypeList()), (Object)"in_out_type", (Collection)outFlowVO.getInOutTypeList());
        }
        FlowEntity entity = (FlowEntity)((Object)this.flowService.getOne((Wrapper)queryWrapper));
        BigDecimal taxMny = entity.getTaxMny();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)taxMny);
    }
}

