/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.store.bean.CheckEntity;
import com.ejianc.business.store.bean.PdallEntity;
import com.ejianc.business.store.mapper.PdallMapper;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.service.IPdallService;
import com.ejianc.business.store.vo.PdallVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pdallService")
public class PdallServiceImpl
extends BaseServiceImpl<PdallMapper, PdallEntity>
implements IPdallService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICheckService checkService;
    private static final String BILL_CODE = "PDALL";

    @Override
    public PdallVO saveOrUpdate(PdallVO saveOrUpdateVO) {
        PdallEntity entity = (PdallEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PdallEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        PdallVO vo = (PdallVO)BeanMapper.map((Object)((Object)entity), PdallVO.class);
        String checkId = saveOrUpdateVO.getCheckId();
        String[] split = checkId.split(",");
        List<String> listIds = Arrays.asList(split);
        List<Long> s = listIds.stream().map(Long::parseLong).collect(Collectors.toList());
        this.updateCheck(saveOrUpdateVO.getId(), s);
        return vo;
    }

    @Override
    public void deleteCheckId(List<Long> settleIds) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(CheckEntity::getPdallId, settleIds);
        wrapper.set(CheckEntity::getPdallId, null);
        wrapper.set(CheckEntity::getUseFlag, (Object)0);
        this.checkService.update((Wrapper)wrapper);
    }

    @Override
    public void updateCheck(Long pdallId, List<Long> pdallIds) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(CheckEntity::getPdallId, (Object)pdallId);
        wrapper.set(CheckEntity::getPdallId, null);
        wrapper.set(CheckEntity::getUseFlag, (Object)0);
        this.checkService.update((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty(pdallIds)) {
            pdallIds.forEach(e -> {
                LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
                lambda.eq(BaseEntity::getId, e);
                lambda.set(CheckEntity::getPdallId, (Object)pdallId);
                lambda.set(CheckEntity::getUseFlag, (Object)1);
                this.checkService.update((Wrapper)lambda);
            });
        }
    }
}

