package com.ejianc.business.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.store.bean.CheckDetailEntity;
import com.ejianc.business.store.bean.CheckEntity;
import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.store.vo.CheckDetailVO;
import com.ejianc.business.store.vo.CheckVO;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.PickReturnVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 仓库盘点表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("check")
public class CheckController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFlowService flowService;
    @Autowired
    private ICheckSupplierApi checkSupplierApi;


    private static final String BILL_CODE = "STORE_CHECK_CODE";//此处需要根据实际修改

    @Autowired
    private ICheckService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private CheckBpmServiceImpl check;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveOrUpdateVO) {
        CheckVO checkVO = service.saveOrUpdate(saveOrUpdateVO);

        return CommonResponse.success("保存或修改单据成功！",checkVO);
    }

    /**
     * 成本改造
     * 关联保存接口
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> pushCost(@RequestBody CheckVO checkVO) {
        return service.pushCost(checkVO);
    }
    /**
     * 单据管控
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody CheckVO checkVO) {
        return CommonResponse.success("参数校验成功！", service.checkParams(checkVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(Long id) {
    	CheckEntity entity = service.selectById(id);
    	CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/querySubDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CheckDetailVO>> querySubDetail(@RequestParam(value = "materialIds") List<Long> materialIds
            ,@RequestParam(value = "projectId",required = false) Long projectId
            ,@RequestParam(value = "storeId") Long storeId
            ,@RequestParam(value = "sourceBillDate") String sourceBillDate) {
        List<CheckDetailVO> detailVOList = service.querySubDetail(materialIds,projectId,storeId,sourceBillDate);
        return CommonResponse.success("查询详情数据成功！",detailVOList);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CheckVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                //删除实际成本
                CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(vo.getId());
                logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
                if(!stringCommonResponse.isSuccess()){
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            }
        }
        service.myRemoveByIds(vos.stream().map(CheckVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Description checkByDate 根据仓库，时间校验是否存在盘点单
     * @Param storeId
     * @Param checkDate
     */
    @RequestMapping(value = "/checkByDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse checkByDate(Long storeId,String checkDate){
        return service.checkByDate(storeId,checkDate);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "projectName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "orgName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
        }
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<CheckEntity> list = service.queryList(param);
        List<CheckVO> checkVOVos = BeanMapper.mapList(list, CheckVO.class);
        checkVOVos.forEach(item->{
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", checkVOVos);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }

    /**
     * 仓库盘点物资列表导出
     *
     * @param
     * @param response
     */
    @PostMapping("excelExportMaterialList")
    public void excelExportMaterialList(@RequestBody CheckVO checkVO, HttpServletResponse response) {
        CheckEntity entity = service.selectById(checkVO.getId());
        DecimalFormat df = new DecimalFormat("#,##0.00");

        Map<String, Object> beans = new HashMap();
        List<CheckDetailVO> list= new ArrayList<>();
        List<CheckDetailEntity> data = entity.getCheckSubList();
        if(CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                CheckDetailVO vo = BeanMapper.map(item, CheckDetailVO.class);
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("checkDetailExport.xlsx", beans, response);
    }


    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }
        param.getParams().put("useFlag", new Parameter(QueryParam.EQ, 0));
        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     @RequestMapping(value = "/getNewPrice", method = RequestMethod.GET)
     @ResponseBody
     public CommonResponse<FlowVO> getNewPrice(Long storeId,Long materialId){
         QueryWrapper<FlowEntity> wrapper = new QueryWrapper();
         wrapper.eq("store_id", storeId);
         wrapper.eq("material_id", materialId);
         wrapper.eq("in_out_flag", StoreCommonConsts.IN_OUT_TYPE_IN);
         wrapper.orderByDesc("source_bill_date");
         wrapper.last("limit 0,1");
         FlowEntity flowEntity = flowService.list(wrapper).get(0);
         FlowVO vo = BeanMapper.map(flowEntity, FlowVO.class);
         return CommonResponse.success("查询数据成功！",vo);
     }

    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckSupplierDTO> test(Long id){
        CommonResponse<CheckSupplierDTO> checkSupplierDTOCommonResponse = checkSupplierApi.queryCheckDTO(id);
        return checkSupplierDTOCommonResponse;
    }


}
