package com.ejianc.business.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 调拨结算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_allot_settle")
public class AllotSettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 出库项目id
    @TableField(value="project_name")
    private String projectName; // 出库项目名称
    @TableField(value="org_id")
    private Long orgId; // 出库组织id
    @TableField(value="org_code")
    private String orgCode; // 出库组织编码
    @TableField(value="org_name")
    private String orgName; // 出库组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="out_date")
    private Date outDate; // 调出的时间
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; //  经办人部门
    @TableField(value="in_project_id")
    private Long inProjectId; // 调入项目id
    @TableField(value="in_project_name")
    private String inProjectName; // 调入项目名称
    @TableField(value="in_org_id")
    private Long inOrgId; // 调入组织id
    @TableField(value="in_org_code")
    private String inOrgCode; // 调入组织编码
    @TableField(value="in_org_name")
    private String inOrgName; // 调入组织名称
    @TableField(value="in_parent_org_id")
    private Long inParentOrgId; // 调入项目部上级组织Id
    @TableField(value="in_parent_org_name")
    private String inParentOrgName; // 调入项目部上级组织名称
    @TableField(value="in_parent_org_code")
    private String inParentOrgCode; // 调入项目部上级组织编码
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="receive_date")
    private Date receiveDate; // receiveDate
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态
    @TableField(value="settlement_tax_mny")
    private BigDecimal settlementTaxMny; // 结算金额
    @TableField(value="settlement_mny")
    private BigDecimal settlementMny; // 结算金额(无税)
    @TableField(value="settlement_tax")
    private BigDecimal settlementTax; // 结算税额
    @TableField(value="settle_type")
    private Integer settleType; // 结算类型，0-过程,1-最终
    @TableField(value="settle_date")
    private Date settleDate; // 对账日期

    @TableField(exist=false)
    @SubEntity(serviceName="allotSettleDetailService",pidName ="settleId")
    private List<AllotSettleDetailEntity> allotSettleDetailList = new ArrayList<>(); // 调拨结算子表

    public List<AllotSettleDetailEntity> getAllotSettleDetailList() {
        return allotSettleDetailList;
    }

    public void setAllotSettleDetailList(List<AllotSettleDetailEntity> allotSettleDetailList) {
        this.allotSettleDetailList = allotSettleDetailList;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getInProjectId() {
        return inProjectId;
    }

    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }
    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }
    public Long getInOrgId() {
        return inOrgId;
    }

    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgCode() {
        return inOrgCode;
    }

    public void setInOrgCode(String inOrgCode) {
        this.inOrgCode = inOrgCode;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    public Long getInParentOrgId() {
        return inParentOrgId;
    }

    public void setInParentOrgId(Long inParentOrgId) {
        this.inParentOrgId = inParentOrgId;
    }
    public String getInParentOrgName() {
        return inParentOrgName;
    }

    public void setInParentOrgName(String inParentOrgName) {
        this.inParentOrgName = inParentOrgName;
    }
    public String getInParentOrgCode() {
        return inParentOrgCode;
    }

    public void setInParentOrgCode(String inParentOrgCode) {
        this.inParentOrgCode = inParentOrgCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }
    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }
    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }
    
}
