package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.store.bean.ApplyDetailEntity;
import com.ejianc.business.store.bean.ApplyEntity;
import com.ejianc.business.store.bean.DisposeDetailEntity;
import com.ejianc.business.store.bean.DisposeEntity;
import com.ejianc.business.store.mapper.DisposeMapper;
import com.ejianc.business.store.service.IApplyDetailService;
import com.ejianc.business.store.service.IApplyService;
import com.ejianc.business.store.service.IDisposeDetailService;
import com.ejianc.business.store.service.IDisposeService;
import com.ejianc.business.store.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 废旧物资处理明细
 * 
 * @author generator
 * 
 */
@Service("disposeService")
public class DisposeServiceImpl extends BaseServiceImpl<DisposeMapper, DisposeEntity> implements IDisposeService{
    private static final String REFER_CACHE_KEY = "refer_cache_key:";

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IApplyService applyService;

    @Autowired
    private IDisposeDetailService detailService;

    @Autowired
    private IApplyDetailService applyDetailService;

    @Override
    public void updateApply(Long disposeId, List<Long> applyIds) {
        LambdaUpdateWrapper<ApplyEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ApplyEntity::getDisposeId, disposeId);
        wrapper.set(ApplyEntity::getDisposeId, null);
        wrapper.set(ApplyEntity::getUseFlag, 0);
        applyService.update(wrapper);
        if (CollectionUtils.isNotEmpty(applyIds)) {
            LambdaUpdateWrapper<ApplyEntity> lw = new LambdaUpdateWrapper();
            lw.in(ApplyEntity::getId, applyIds);
            lw.set(ApplyEntity::getDisposeId, disposeId);
            lw.set(ApplyEntity::getUseFlag,1);
            applyService.update(lw);
        }
    }

    @Override
    public JSONObject disposeReport(QueryParam param) {
        JSONObject page = new JSONObject();
        page.put("current", "" + param.getPageIndex());
        page.put("size", "" + param.getPageSize());
        page.put("records", new ArrayList<>());
        page.put("total", "" + 0);
        page.put("pages", "" + 0);

        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        String order = QueryParam.DESC;
        if(orderMap.containsKey("applyDate")){
            order = orderMap.get("applyDate");
            orderMap.remove("applyDate");
        }

        QueryParam queryParam = new QueryParam();
        // 处理Params
        Map<String, Parameter> params = this.transferParams(param.getParams(), "applyDate", "orgName", "projectName", "supplierName", "employeeName");
        queryParam.setParams(params);

        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId())
                .getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DisposeEntity> list = super.queryList(queryParam);
        if(CollectionUtils.isEmpty(list)){
            return page;
        }
        Map<Long, DisposeEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        param.getParams().put("mid", new Parameter(QueryParam.IN, new ArrayList<>(map.keySet())));
        IPage<DisposeDetailEntity> pageData = detailService.queryPage(param);
        List<DisposeDetailEntity> detailList = pageData.getRecords();
        page.put("current", "" + pageData.getCurrent());
        page.put("size", "" + pageData.getSize());
        page.put("records", pageData.getRecords());
        page.put("total", "" + pageData.getTotal());
        page.put("pages", "" + pageData.getPages());

        Map<Long, ApplyDetailEntity> applyMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            List<Long> ids = detailList.stream().map(x->x.getApplyDetailId()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            QueryParam dParam = new QueryParam();
            dParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ApplyDetailEntity> applyList = applyDetailService.queryList(dParam);
            applyMap = applyList.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        }

        JSONArray array = new JSONArray();
        for(DisposeDetailEntity detail : detailList){
            DisposeEntity entity = map.get(detail.getMid());
            JSONObject obj = JSONObject.parseObject(JSON.toJSONString(detail));
            obj.put("orgName", entity.getOrgName());// 所属组织
            obj.put("projectName", entity.getProjectName());// 项目名称
            obj.put("supplierName", entity.getSupplierName());// 收购单位
            obj.put("applyDate", DateUtil.formatDate(entity.getApplyDate()));// 处理时间
            obj.put("employeeName", entity.getEmployeeName());// 联系人
            obj.put("mobilePhone", getMobileByUserId(entity.getEmployeeId()));// 电话
            if(applyMap.containsKey(detail.getApplyDetailId())){
                obj.put("applyNum", applyMap.get(detail.getApplyDetailId()).getCheckNum());// 申请数量
            }
            array.add(obj);
        }
        if(QueryParam.ASC.equals(order)){
            array = array.stream().sorted(Comparator.comparing(x->((JSONObject) x).getString("applyDate"))).collect(Collectors.toCollection(JSONArray::new));
        } else {
            array = array.stream().sorted(Comparator.comparing(x->((JSONObject) x).getString("applyDate")).reversed()).collect(Collectors.toCollection(JSONArray::new));
        }
        page.put("records", array);
        return page;
    }

    /**
     * 处理Params
     * @param params
     * @param fields
     * @return
     */
    private static Map<String, Parameter> transferParams(Map<String, Parameter> params, String... fields) {
        Map<String, Parameter> map = new HashMap<>();
        if(null == params){
            return map;
        }
        for(String field : fields){
            if(params.containsKey(field)){
                map.put(field, params.get(field));
                params.remove(field);
            }
        }
        return map;
    }

    /**
     * 根据人员主键查询人员电话
     * @param userId
     * @return
     */
    private String getMobileByUserId(Long userId) {
        try {
            MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
            if (userId != null && StringUtils.isNotBlank(urlconstants.getBaseHost())) {
                String cacheKey = REFER_CACHE_KEY + "idm-employee:" + userId;
                RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
                if (cacheValue != null) {
                    JSONArray jsonArray = JSONArray.parseArray(cacheValue.toString());
                    JSONObject jsonObject = JSONObject.parseObject(jsonArray.get(0).toString());
                    return jsonObject.getString("mobilePhone");
                } else {
                    CommonResponse<EmployeeVO> resp = employeeApi.queryEmployeByUserId(userId);
                    if(resp.isSuccess()){
                        return resp.getData().getMobilePhone();
                    }
                }
            }
        } catch (Exception e) {
        }
        return null;
    }
}
