package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.bean.CheckDetailEntity;
import com.ejianc.business.store.bean.CheckEntity;
import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.controller.FlowController;
import com.ejianc.business.store.mapper.CheckDetailMapper;
import com.ejianc.business.store.mapper.CheckMapper;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.utils.CommonUtils;
import com.ejianc.business.store.vo.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import nu.xom.jaxen.util.SingletonList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 仓库盘点表
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private CheckDetailMapper checkDetailMapper;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private CheckMapper checkMapper;
    private static final String BILL_CODE = "STORE_CHECK_CODE";//此处需要根据实际修改


    @Autowired
    private StoreManageService storeManageService;

    @Autowired
    private FlowController flowHandle;

    @Autowired
    private IFlowService flowService;

    // 推送成本需要调用的接口 start
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICheckService service;

    @Override
    public CommonResponse saveCheckStore(CheckEntity entity) {
        Long projectId = entity.getProjectId();
        Long storeId = entity.getStoreId();

        QueryWrapper<CheckEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id",projectId);
        wrapper.eq("store_id",storeId);
        wrapper.eq("bill_state",StoreCommonConsts.ZERO);
        wrapper.eq("account_subject", entity.getAccountSubject());
        List<CheckEntity> list = super.list(wrapper);
        Integer checkCount = list.size();
        if(null == entity.getId()){
            if(checkCount > 0) {
                return CommonResponse.error("该仓库已下存在自由态盘点单！");
            }
        }else{
            if(checkCount > 1) {
                return CommonResponse.error("该仓库已下存在自由态盘点单！");
            }
        }
//        //更新子表信息
//        if(null != entity.getId()) {
//            checkDetailMapper.delByCheckId(entity.getId());
//        }
        if(null != entity.getId()){
            // 盘亏改盘盈，出库流水未删除
            this.checkRollback(new SingletonList(entity.getId()));
        }
        super.saveOrUpdate(entity, false);
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        List<CheckDetailEntity> subList = new ArrayList<>();
        checkSubList.forEach(item->{
            if(item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0){
                subList.add(item);
            }
        });

        // 校验提交时数量是否足够
        Map<Long,FlowVO> checkMap = new HashMap<>();
        String materialIds = "[";
        for (CheckDetailEntity item:subList
             ) {
            materialIds = materialIds + item.getMaterialId()+",";
        }
        materialIds = materialIds.substring(0,materialIds.length()-1)+"]";
        String condition = "{projectId:"+entity.getProjectId()+",storeId:"+entity.getStoreId()+",materialIds:"+materialIds+"}";
        // 本次盘点包含出库单时进行校验。
        if(subList.size() > 0){
            CommonResponse<IPage<FlowVO>> iPageCommonResponse = flowHandle.refInstoreFlowData(1, 1000, condition, "", "");
            if(!iPageCommonResponse.isSuccess() || null == iPageCommonResponse.getData()){
                return CommonResponse.error("获取最新数量失败！");
            }
            List<FlowVO> records = iPageCommonResponse.getData().getRecords();
            records.forEach(item->{
                checkMap.put(item.getMaterialId(),item);
            });
            for (CheckDetailEntity item:subList
                 ) {
                FlowVO flowVO = checkMap.get(item.getMaterialId());
                // 库存可用为0时
                if(null == flowVO){
                    return CommonResponse.error("【"+item.getMaterialName()+"_"+item.getSpec()+"】库存可用数量不足，无法形成盘亏出库单；  不可保存");
                }
                // 校验库存是否足够出库单使用
                if(item.getInventory().add(flowVO.getSurplusNum()).compareTo(BigDecimal.ZERO) < 0){
                    return CommonResponse.error("【"+item.getMaterialName()+"_"+item.getSpec()+"】库存可用数量不足，无法形成盘亏出库单；  不可保存");
                }
            }
        }

        if(subList.size() > 0){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            subList.forEach(item->{
                if(item.getInventory() == null) item.setInventory(BigDecimal.ZERO);
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.盘亏出库,0);
                flowVO.setSourceBillTypeName("盘点出库");
                flowVO.setSourceBillTypeCode("BT220125000000009");
                flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(BigDecimal.ZERO.subtract(item.getInventory()));
//                if(null != item.getPrice()){
//                    flowVO.setTaxPrice(item.getPrice());
//                    flowVO.setTaxMny(item.getPrice().multiply(flowVO.getNum()));
//                }
                flowVO.setPrice(item.getPrice());
                flowVO.setTaxPrice(item.getTaxPrice());
                flowVO.setMny(ComputeUtil.safeMultiply(item.getPrice(), flowVO.getNum()));
                flowVO.setTaxMny(ComputeUtil.safeMultiply(item.getTaxPrice(), flowVO.getNum()));
                flowVO.setTax(ComputeUtil.safeSub(flowVO.getTaxMny(), flowVO.getMny()));
                flowVO.setMaterialUnitId(item.getUnit());
                flowVO.setMaterialUnitName(item.getUnitName());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getCheckDate());
                flowVO.setRowState(item.getRowState());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = storeManageService.surplusMaterialPrice(storeManageVO);
            if(!commonResponse.isSuccess()){
                return commonResponse;
            }
            List<UseMaterialPriceVO> useMaterialPriceVOList = new ArrayList<>();
            if(null != commonResponse.getData()){
                useMaterialPriceVOList = commonResponse.getData().getUseMaterialPriceVOList();
            }
            Map<Long, UseMaterialPriceVO> priceMap = useMaterialPriceVOList.stream().collect(Collectors.toMap(k -> k.getMaterialId(), (k) -> k));

//            // 获取价格后再更新子表信息
//            if(null != entity.getId()) {
//                checkDetailMapper.delByCheckId(entity.getId());
//            }
            BigDecimal costMny = BigDecimal.ZERO;
            BigDecimal costTaxMny = BigDecimal.ZERO;
            entity.getCheckSubList().forEach(item->{
                if(null != priceMap.get(item.getMaterialId())){
                    item.setPrice(ComputeUtil.scaleTwo(priceMap.get(item.getMaterialId()).getPrice()));
                    item.setTaxPrice(ComputeUtil.scaleTwo(priceMap.get(item.getMaterialId()).getTaxPrice()));
                    BigDecimal taxMny = ComputeUtil.scaleTwo(BigDecimal.ZERO.subtract(priceMap.get(item.getMaterialId()).getTaxMny()));
                    BigDecimal mny = ComputeUtil.scaleTwo(BigDecimal.ZERO.subtract(priceMap.get(item.getMaterialId()).getMny()));
                    item.setCostTaxMny(BigDecimal.ZERO.subtract(taxMny));
                    item.setCostMny(BigDecimal.ZERO.subtract(mny));
                }
            });

            for (CheckDetailEntity item:entity.getCheckSubList()
                 ) {
                if(item.getCostMny() != null){
                    costMny = costMny.add(item.getCostMny());
                }
                if(item.getCostTaxMny() != null){
                    costTaxMny = costTaxMny.add(item.getCostTaxMny());
                }
            }
            entity.setCostMny(costMny);
            entity.setCostTaxMny(costTaxMny);
            super.saveOrUpdate(entity, false);
            checkSubList = entity.getCheckSubList();
            subList.clear();
            checkSubList.forEach(item->{
                if(item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0){
                    subList.add(item);
                }
            });

            flowVOS.forEach(item->{
                item.setPrice(priceMap.get(item.getMaterialId()).getPrice());
                item.setTaxPrice(priceMap.get(item.getMaterialId()).getTaxPrice());
                item.setMny(priceMap.get(item.getMaterialId()).getMny());
                item.setTaxMny(priceMap.get(item.getMaterialId()).getTaxMny());
                item.setTax(ComputeUtil.safeSub(item.getTaxMny(), item.getMny()));
            });
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStore(storeManageVO);
            if(!storeManageVOCommonResponse.isSuccess()){
                return storeManageVOCommonResponse;
            }
        }
        return CommonResponse.success(entity);
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = checkRollback(ids);
        if(!commonResponse.isSuccess()){
            return commonResponse;
        }
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }
    @Override
    public CommonResponse checkRollback(List<Long> ids){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
             ) {
            CheckEntity entity = super.selectById(item);
            List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
            Boolean checkFalg = false;
            for (CheckDetailEntity t:checkSubList) {
                if(t.getInventory().compareTo(BigDecimal.ZERO) < 0){
                    checkFalg = true;
                    break;
                }
            }
            // 包含出库单，才需要此操作。
            if(checkFalg){
                SourceIds.clear();
                SourceIds.add(item);
                storeManageVO.setSourceId(item);
                storeManageVO.setStoreId(entity.getStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
                storeManageVO.setSourceIdsForRollBack(SourceIds);
                CommonResponse<StoreManageVO> rollbackCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
                if(!rollbackCommonResponse.isSuccess()){
                    return rollbackCommonResponse;
                }
            }
        }
        return CommonResponse.success();
    };
    @Override
    public CommonResponse checkOut(List<Long> ids){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
        ) {
            CheckEntity entity = super.selectById(item);
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setSourceId(item);
            storeManageVO.setOutEffectiveON(true);
            CommonResponse<StoreManageVO> rollbackCommonResponse = storeManageService.inOutStore(storeManageVO);
            if(!rollbackCommonResponse.isSuccess()){
                return rollbackCommonResponse;
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkByDate(Long storeId, String checkDate) {
        List<CheckEntity> checkEntities = checkMapper.queryByDate(storeId, checkDate);
        if(checkEntities.size()>0){
            return CommonResponse.error("该时间点后已发生仓库盘点单");
        }
        return CommonResponse.success();
    }


    @Override
    public CommonResponse<CheckVO> pushCost(CheckVO checkVO) {
        CheckEntity checkEntity = baseMapper.selectById(checkVO.getId());
        if (CollectionUtils.isNotEmpty(checkVO.getCheckSubList())) {
            List<CheckDetailEntity> checkDetailEntities = BeanMapper.mapList(checkVO.getCheckSubList(), CheckDetailEntity.class);
            checkEntity.setCheckSubList(checkDetailEntities);
        }
        super.saveOrUpdate(checkEntity, false);
        //推送数据
        this.costPush(checkEntity);
        return CommonResponse.success(BeanMapper.map(checkEntity, CheckVO.class));
    }

    @Override
    public void costPush(CheckEntity checkEntity) {
        logger.info("开始costPush");
        List<CheckDetailEntity> checkDetailEntities = checkEntity.getCheckSubList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailEntities)) {
            for (CheckDetailEntity entity : checkDetailEntities) {
                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(checkDetailEntities)) {
            newRelationFlag = "0";
        }
        // 全部挂接成本科目才推送目标成本
        if("1".equals(newRelationFlag)){
            saveCost(checkEntity,1);
        }
        //更新是否关联
        LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(CheckEntity::getId, checkEntity.getId());
        updateWrapper.set(CheckEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);

    }

    @Override
    public CheckVO saveOrUpdate(CheckVO saveOrUpdateVO) {
        CheckEntity entity = BeanMapper.map(saveOrUpdateVO, CheckEntity.class);

        if(!ListUtil.isEmpty(saveOrUpdateVO.getCheckSubList())){
            entity.setCheckSubList(BeanMapper.mapList(saveOrUpdateVO.getCheckSubList(), CheckDetailEntity.class));
        }
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setProportionFlag("0"); // 初始化标识
                entity.setRelationFlag("0"); // 初始化标识
                entity.setUseFlag(0); // 初始化标识
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        CommonResponse commonResponse = service.saveCheckStore(entity);
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        //推送实际成本
        saveCost(entity,0);

        CheckVO vo = BeanMapper.map(commonResponse.getData(), CheckVO.class);
        return vo;
    }

    private void saveCost(CheckEntity checkEntity,Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<CheckDetailEntity> checkSubList = checkEntity.getCheckSubList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkSubList)) {
            //根据物资id查询物资编码
            List<Long> materialIds = checkSubList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse<List<MaterialVO>> listCommonResponse = shareMaterialApi.queryMaterialByIds(materialIds);
            List<MaterialVO> voList = new ArrayList<>();
            if(listCommonResponse.isSuccess()){
                voList = listCommonResponse.getData();
            }
            Map<Long, String> materialMap = new HashMap<>();
            voList.forEach(item -> materialMap.put(item.getId(),item.getCode()));
            for (CheckDetailEntity entity : checkSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getCheckId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getCostTaxMny());
                costDetailVO.setHappenMny(entity.getCostMny());
                costDetailVO.setHappenDate(checkEntity.getCheckDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("STORE_CHECK");
                costDetailVO.setSourceTabType("STORE_CHECK_SUB");
                //新加的
                costDetailVO.setSourceBillCode(checkEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.仓库盘点.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-store-frontend/#/storeCheck/card?id="+checkEntity.getId());
                costDetailVO.setProjectId(checkEntity.getProjectId());
                //2022-8-16新增传输字段
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode(materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getUnit());
                costDetailVO.setUnit(entity.getUnitName());
                costDetailVO.setSpec(entity.getSpec());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(CheckVO checkVO) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        //--成本科目-目标成本控制
        CostCtrlVO costCtrlVO = this.sjCost(checkVO);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOS.add(costRes);
            }
        }

        //------end有合同预警域
        /*--end---参数控制区域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO paramsCheckVO1 : paramsCheckVOS) {
                String warnType = paramsCheckVO1.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(paramsCheckVO1.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,paramsCheckVO1.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public List<CheckDetailVO> querySubDetail(List<Long> materialIds, Long projectId, Long storeId, String sourceBillDate) {
        QueryWrapper<CheckDetailVO> qw = new QueryWrapper();
        qw.in("material_id",materialIds);
        qw.in("bill_state",Arrays.asList(1,3));
        //qw.eq("projectId",projectId);
        qw.eq("a.dr",0);
        qw.eq("b.dr",0);
        qw.eq("store_id",storeId);
        qw.groupBy("store_id","material_id");
        qw.orderByDesc("a.create_time");
        List<CheckDetailVO> detailVOList = baseMapper.queryAllData(qw);

        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("storeId", new Parameter(QueryParam.EQ, storeId));
        param.getParams().put("checkDate", new Parameter(QueryParam.LT, sourceBillDate));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<CheckEntity> list = super.queryList(param);
        CheckEntity last = list.stream().findFirst().orElse(new CheckEntity());

        LambdaQueryWrapper<FlowEntity> flw = Wrappers.lambdaQuery();
        flw
                //.eq(FlowEntity::getProjectId, projectId)
                .eq(FlowEntity::getStoreId, storeId)
                .in(FlowEntity::getMaterialId, materialIds)
                .gt(last.getCheckDate() != null, FlowEntity::getSourceBillDate, last.getCheckDate())
                .le(FlowEntity::getSourceBillDate, sourceBillDate)
                .eq(FlowEntity::getEffectiveState, 1)
                .eq(FlowEntity::getDr, 0);

        List<FlowEntity> flowList = flowService.list(flw);
        Map<Long,BigDecimal> beginNumMap = new HashMap();
        Map<Long,BigDecimal> beginMnyMap = new HashMap();
        Map<Long,BigDecimal> inStoreNumMap = new HashMap();
        Map<Long,BigDecimal> inStoreMnyMap = new HashMap();
        Map<Long,BigDecimal> inNumMap = new HashMap();
        Map<Long,BigDecimal> inMnyMap = new HashMap();
        Map<Long,BigDecimal> outStoreNumMap = new HashMap();
        Map<Long,BigDecimal> outStoreMnyMap = new HashMap();
        Map<Long,BigDecimal> outNumMap = new HashMap();
        Map<Long,BigDecimal> outMnyMap = new HashMap();
        for (CheckDetailVO checkDetailVO : detailVOList) {
            beginNumMap.merge(checkDetailVO.getMaterialId(), ComputeUtil.nullToZero(checkDetailVO.getCheckNum()), ComputeUtil::safeAdd);
            beginMnyMap.merge(checkDetailVO.getMaterialId(), ComputeUtil.nullToZero(checkDetailVO.getCheckMny()), ComputeUtil::safeAdd);
        }

        for (FlowEntity flowEntity : flowList) {
            Integer inOutType = flowEntity.getInOutType();
            Integer inOutFlag = flowEntity.getInOutFlag();
            Long materialId = flowEntity.getMaterialId();
            BigDecimal num = ComputeUtil.nullToZero(flowEntity.getNum());
            BigDecimal mny = ComputeUtil.nullToZero(flowEntity.getMny());
//            BigDecimal num = ComputeUtil.isNotEmpty(flowEntity.getNum()) ? flowEntity.getNum() : BigDecimal.ZERO;
//            BigDecimal mny = ComputeUtil.isNotEmpty(flowEntity.getMny()) ? flowEntity.getMny() : BigDecimal.ZERO;
            if (1 == inOutFlag && inOutType != InOutTypeEnum.调拨入库.getInOutType()){
                inStoreNumMap.merge(materialId, num, ComputeUtil::safeAdd);
                inStoreMnyMap.merge(materialId, mny, ComputeUtil::safeAdd);
            } else if (inOutType == InOutTypeEnum.调拨入库.getInOutType()){
                inNumMap.merge(materialId, num, ComputeUtil::safeAdd);
                inMnyMap.merge(materialId, mny, ComputeUtil::safeAdd);
            } else if (2 == inOutFlag && inOutType != InOutTypeEnum.调拨出库.getInOutType()){
                outStoreNumMap.merge(materialId, num, ComputeUtil::safeAdd);
                outStoreMnyMap.merge(materialId, mny, ComputeUtil::safeAdd);
            } else if (inOutType == InOutTypeEnum.调拨出库.getInOutType()){
                outNumMap.merge(materialId, num, ComputeUtil::safeAdd);
                outMnyMap.merge(materialId, mny, ComputeUtil::safeAdd);
            }
        }
        String condition = "{projectId:"+projectId+",storeId:"+storeId+",materialIds:["+StringUtils.join(materialIds, ",")+"]}";
        // 本次盘点包含出库单时进行校验。
        CommonResponse<IPage<FlowVO>> resp = flowHandle.refInstoreFlowData(1, 1000, condition, "", "");
        if(!resp.isSuccess() || null == resp.getData()){
            throw new BusinessException("获取最新数量失败！");
        }
        List<FlowVO> records = resp.getData().getRecords();
        Map<Long,FlowVO> flowMap = records.stream().collect(Collectors.toMap(x->x.getMaterialId(), x->x, (v1, v2)->v2));

        List<CheckDetailVO> resList = new ArrayList();
        /**
         * 期初数量:取该分类上次物资盘点单的实际盘点数量
         * 期初无税金额:取该分类上次物资盘点单的实际盘点金额
         * 入库数量:取上次盘点以后，新生效收料入库单入库数量(包含直入直出，不包含 调拨入库):
         * 入库金额:材料入库数量对应的金额
         * 调入数量 :取上次盘点以后，新生效调拨入库单入库数量
         * 调入无税金额:取调拨入库材料对应的金额
         * 消耗数量:取上次盘点以后，新生效材料领料出库单、直入直出单的材料数量
         * 消耗无税金额:取出库材料对应的金额
         * 调出数量:取上次盘点以后，新生效调拨出库单材料数量
         * 调出无税金额:取调拨出库单材料对应的金额
         * 期末账面结存数量:期初数量+调拨入库数量-消耗数量-调出数量
         * 期末账面无税金额:期初金额+调入金额-消耗金额-调出金额
         * 实际盘点数量:默认等于期末账面结存数量，支持修改
         * 实际盘点无税金额:默认等于期末账面结存金额+(实际盘点数量-期末账面结存数量)*(期末账面无税金额/期末账面结存数量)
         * 盘盈盘亏无税金额:(实际盘点数量-期末账面结存数量)*(期末账面无税金额/期末账面结存数量)
         */
        for (Long materialId : materialIds) {
            CheckDetailVO detailVO = new CheckDetailVO();
            detailVO.setMaterialId(materialId);
            detailVO.setBeginNum(beginNumMap.get(materialId));
            detailVO.setBeginMny(beginMnyMap.get(materialId));
            detailVO.setInStoreNum(inStoreNumMap.get(materialId));
            detailVO.setInStoreMny(inStoreMnyMap.get(materialId));
            detailVO.setInNum(inNumMap.get(materialId));
            detailVO.setInMny(inMnyMap.get(materialId));
            detailVO.setOutStoreNum(outStoreNumMap.get(materialId));
            detailVO.setOutStoreMny(outStoreMnyMap.get(materialId));
            detailVO.setOutNum(outNumMap.get(materialId));
            detailVO.setOutMny(outMnyMap.get(materialId));

//            detailVO.setAccNum(ComputeUtil.safeAdd(beginNumMap.get(materialId),inStoreNumMap.get(materialId),inNumMap.get(materialId)
//                    ,ComputeUtil.convertToMinusNumber(outStoreNumMap.get(materialId)),ComputeUtil.convertToMinusNumber(outNumMap.get(materialId))));
//            detailVO.setAccAmount(ComputeUtil.safeAdd(beginMnyMap.get(materialId),inStoreMnyMap.get(materialId),inMnyMap.get(materialId)
//                    ,ComputeUtil.convertToMinusNumber(outStoreMnyMap.get(materialId)),ComputeUtil.convertToMinusNumber(outMnyMap.get(materialId))));
            if(flowMap.containsKey(materialId)){
                detailVO.setAccNum(flowMap.get(materialId).getSurplusNum());
                detailVO.setAccAmount(flowMap.get(materialId).getSurplusMny());
            }
            detailVO.setCheckNum(detailVO.getAccNum());
            detailVO.setCheckMny(detailVO.getAccAmount());
            detailVO.setInventoryMny(BigDecimal.ZERO);
            detailVO.setInventory(BigDecimal.ZERO);
            resList.add(detailVO);
        }
        return resList;
    }

    /**
     *成本科目目标成本控制
     *
     */
    public CostCtrlVO sjCost(CheckVO vo){


        List<CheckDetailVO> checkSubList = vo.getCheckSubList();
        if(CollectionUtils.isNotEmpty(checkSubList)){
            Map<Long,CostCtrlDetailVO> map = new HashMap<>();
            for(CheckDetailVO pickReturnDetailVO:checkSubList){
                if(null!=pickReturnDetailVO.getSubjectId() &&!"del".equals(pickReturnDetailVO.getRowState())){
                    BigDecimal detailMny = CommonUtils.setBigDecimalDefaultValue(pickReturnDetailVO.getCostMny());
                    BigDecimal detailTaxMny = CommonUtils.setBigDecimalDefaultValue(pickReturnDetailVO.getCostTaxMny());
                    if(map.containsKey(pickReturnDetailVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(pickReturnDetailVO.getSubjectId());
                        BigDecimal mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                        BigDecimal taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                        costCtrlDetailVO.setMny(mny.add(detailMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(pickReturnDetailVO.getSubjectId());
                        costCtrlDetailVO.setMny(detailMny);
                        costCtrlDetailVO.setTaxMny(detailTaxMny);
                        map.put(pickReturnDetailVO.getSubjectId(),costCtrlDetailVO);
                    }
                }
            }

            if(null!=map && !map.isEmpty()){
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if(null!=vo.getId()){
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList<>(map.values()));
                return ctrlVO;
            }else{
                return null;
            }
        }
        return null;
    }

}
