/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.bean.HandleDetailEntity;
import com.ejianc.business.store.bean.HandleEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.mapper.HandleDetailMapper;
import com.ejianc.business.store.mapper.HandleMapper;
import com.ejianc.business.store.service.IHandleService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.HandleDetailVO;
import com.ejianc.business.store.vo.HandleVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handleService")
public class HandleServiceImpl
extends BaseServiceImpl<HandleMapper, HandleEntity>
implements IHandleService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HandleDetailMapper handleDetailMapper;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public CommonResponse saveCheckHandle(HandleEntity entity) {
        if (null != entity.getId()) {
            this.handleDetailMapper.delByHandleId(entity.getId());
        }
        ArrayList<HandleDetailEntity> subList = new ArrayList<HandleDetailEntity>();
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        String names = "";
        for (HandleDetailEntity detailEntity : handleSubList) {
            if (detailEntity.getHandleNum() != null && detailEntity.getHandleNum().compareTo(BigDecimal.ZERO) > 0) {
                subList.add(detailEntity);
            }
            names = names + detailEntity.getMaterialCategoryName() + ",";
        }
        if (handleSubList.size() > 0) {
            names = names.substring(0, names.length() - 1);
        }
        entity.setMaterialTypes(names);
        super.saveOrUpdate((Object)entity, false);
        if (subList.size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u5904\u7f6e);
            ArrayList flowVOS = new ArrayList();
            subList.forEach(item -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6750\u6599\u5904\u7f6e, (Integer)0);
                flowVO.setSourceBillTypeName("\u5904\u7f6e\u51fa\u5e93");
                flowVO.setSourceBillTypeCode("BT220125000000010");
                flowVO.setSourceType(StoreCommonConsts.ZERO);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(item.getHandleNum());
                flowVO.setTaxPrice(item.getHandlePrice());
                flowVO.setTaxMny(item.getHandleMny());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getHandleDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (!commonResponse.isSuccess()) {
                return commonResponse;
            }
        }
        return CommonResponse.success((Object)((Object)entity));
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = this.handleInOut(ids, false);
        if (!commonResponse.isSuccess()) {
            return commonResponse;
        }
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse handleInOut(List<Long> ids, Boolean outEffectiveON) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            HandleEntity entity = (HandleEntity)((Object)super.selectById((Serializable)item));
            List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
            Boolean checkFlag = false;
            for (HandleDetailEntity t : handleSubList) {
                if (t.getHandleNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                checkFlag = true;
                break;
            }
            if (!checkFlag.booleanValue()) continue;
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u5904\u7f6e);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            CommonResponse<StoreManageVO> commonResponse = outEffectiveON != false ? this.storeManageService.inOutStore(storeManageVO) : this.storeManageService.inOutStoreRollback(storeManageVO);
            if (commonResponse.isSuccess()) continue;
            return commonResponse;
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<HandleVO> pushCost(HandleVO handleVO) {
        HandleEntity handleEntity = (HandleEntity)((Object)((HandleMapper)this.baseMapper).selectById(handleVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)handleVO.getHandleSubList())) {
            List handleDetailEntities = BeanMapper.mapList((Iterable)handleVO.getHandleSubList(), HandleDetailEntity.class);
            handleEntity.setHandleSubList(handleDetailEntities);
        }
        super.saveOrUpdate((Object)handleEntity, false);
        this.costPush(handleEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)handleEntity), HandleVO.class));
    }

    @Override
    public void costPush(HandleEntity handleEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<HandleDetailEntity> handleSubList = handleEntity.getHandleSubList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handleSubList)) {
            for (HandleDetailEntity entity : handleSubList) {
                if (null != entity.getSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(handleSubList)) {
            newRelationFlag = "0";
        }
        this.saveCost(handleEntity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{handleEntity.getId()});
        updateWrapper.set(HandleEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public void saveCost(HandleEntity handleEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<HandleDetailEntity> handleSubList = handleEntity.getHandleSubList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handleSubList)) {
            List materialIds = handleSubList.stream().map(HandleDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.shareMaterialApi.queryMaterialByIds(materialIds);
            List voList = new ArrayList();
            if (listCommonResponse.isSuccess()) {
                voList = (List)listCommonResponse.getData();
            }
            HashMap materialMap = new HashMap();
            voList.forEach(item -> materialMap.put(item.getId(), item.getCode()));
            for (HandleDetailEntity entity : handleSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getHandleId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getHandleSubTaxMny());
                costDetailVO.setHappenMny(entity.getHandleSubMny());
                costDetailVO.setHappenDate(handleEntity.getHandleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("STORE_HANDLE");
                costDetailVO.setSourceTabType("STORE_HANDLE_SUB");
                costDetailVO.setSourceBillCode(handleEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u6750\u6599\u5904\u7f6e\u5355.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-store-frontend/#/storeHandle/card?id=" + handleEntity.getId());
                costDetailVO.setProjectId(handleEntity.getProjectId());
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode((String)materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getUnit());
                costDetailVO.setUnit(entity.getUnitName());
                costDetailVO.setSpec(entity.getSpec());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(HandleVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if (null != costCtrlVO) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOS.add(costRes);
            }
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(HandleVO vo) {
        List feeList = vo.getHandleSubList();
        if (CollectionUtils.isNotEmpty((Collection)feeList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (HandleDetailVO handleDetailVO : feeList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal feeTaxMny;
                if (null == handleDetailVO.getSubjectId() || "del".equals(handleDetailVO.getRowState())) continue;
                BigDecimal feeMny = handleDetailVO.getHandleSubMny() == null ? BigDecimal.ZERO : handleDetailVO.getHandleSubMny();
                BigDecimal bigDecimal = feeTaxMny = handleDetailVO.getHandleSubTaxMny() == null ? BigDecimal.ZERO : handleDetailVO.getHandleSubTaxMny();
                if (map.containsKey(handleDetailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(handleDetailVO.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(feeMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(feeTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(handleDetailVO.getSubjectId());
                costCtrlDetailVO.setMny(feeMny);
                costCtrlDetailVO.setTaxMny(feeTaxMny);
                map.put(costCtrlDetailVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && map.size() > 0) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }
}

