package com.ejianc.business.sub.api;

import com.ejianc.business.sub.hystrix.SubWarnHystrix;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "ejc-sub-web", url="${common.env.feign-client-url}", path="ejc-sub-web", fallback = SubWarnHystrix.class)
public interface ISubWarnApi {
    @PostMapping(value = "/api/subWarn/subProjectOutMny")
    CommonResponse<List<SubWarnVo>> subProjectOutMny(@RequestBody List<Long> tenantIds);
}
