package com.ejianc.business.sub.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sub.hystrix.SubReportHystrix;
import com.ejianc.business.sub.vo.SettlePickDeductVO;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

@FeignClient(name= "ejc-sub-web", url="${common.env.feign-client-url}", path="ejc-sub-web", fallback = SubReportHystrix.class)
public interface ISubReportApi {
    /**
     * 查分包合同结算
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/api/sub/getMonthSubMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubProjectReportVo>> getMonthSubMny(@RequestParam(value = "projectId") Long projectId,
                                                                   @RequestParam(value = "lastDay") Integer lastDay);
    /**
     * 查分包合同数量，金额，结算金额
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/api/sub/getSubContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubProjectReportVo> getSubContract(@RequestParam(value = "projectId") Long projectId);

    /**
     * 查分包合同结算工程量
     *
     * @param projectIds
     * @return
     */
    @RequestMapping(value = "/api/sub/getSubSettleNum", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<SubProjectSettleNumVO>> getSubSettleNum(@RequestParam("projectIds") List<Long> projectIds);

    /**
     * @Author mrsir_wxp
     * @Date 2021/5/13 根据 项目ids查询累计结算(含税)  包括过程结算和完工结算
     * @Description querySubSettleMoneyByTypeAndProjectIds
     * @Param [param]
     * projectId 该类项目id集合
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @RequestMapping(value = "/api/sub/querySubSettleMoneyByTypeAndProjectIds", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<BigDecimal> querySubSettleMoneyByTypeAndProjectIds(@RequestBody QueryParam param);

    /**
     * 查分包过程结算和完工结算金额
     *
     * @return
     */
    @RequestMapping(value = "/api/sub/queryLastSettlePickDeductMnyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SettlePickDeductVO>> queryLastSettlePickDeductMnyList(@RequestBody QueryParam param);

}
