package com.ejianc.business.sub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * <p>
 * 分包过程结算零工表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public class SettleOddjobVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 过程结算ID
     */
    private Long settleId;

    /**
     * 零工ID
     */
    private Long oddjobId;

    /**
     * 零工单号
     */
    private String billCode;

    /**
     * 零工总金额
     */
    private BigDecimal jobMny;

    /**
     * 零工总金额（含税）
     */
    private BigDecimal jobTaxMny;

    /**
     * 结算金额
     */
    private BigDecimal settleMny;

    /**
     * 用工摘要
     */
    private String roundup;

    /**
     * 备注
     */
    private String memo;

    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;


    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }


    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    public Long getOddjobId() {
        return oddjobId;
    }

    public void setOddjobId(Long oddjobId) {
        this.oddjobId = oddjobId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getJobMny() {
        return jobMny;
    }

    public void setJobMny(BigDecimal jobMny) {
        this.jobMny = jobMny;
    }
    public BigDecimal getJobTaxMny() {
        return jobTaxMny;
    }

    public void setJobTaxMny(BigDecimal jobTaxMny) {
        this.jobTaxMny = jobTaxMny;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public String getRoundup() {
        return roundup;
    }

    public void setRoundup(String roundup) {
        this.roundup = roundup;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
