package com.ejianc.business.sub.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.othprice.api.IPicketageApi;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.mapper.ContractMapper;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.ExcelImportUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.*;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String SUB_CONTRACT_BILL_CODE = "SUB_CONTRACT";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;

    @Autowired
    private IChangeService changeService;

    @Autowired
    private IPicketageApi picketageApi;


    //【预算人工费总金额】控【劳务分包合同总金额】
    private static String PARAM_LABOR_MNY = "P-9P63m148";
    //预算人工费清单量控
    private static String PARAM_LABOR_DETAIL_NUM = "P-J7c50750";
    //预算人工费清单金额控
    private static String PARAM_LABOR_DETAIL_MNY = "P-rj09ju51";
    //【预算专业分包总金额】控 【专业分包合同总金额】
    private static String PARAM_MAJOR_MNY = "P-k3cSoQ49";
    //预算专业分包清单量控
    private static String PARAM_MAJOR_DETAIL_NUM = "P-5Z9ASh54";
    //预算专业分包清单金额控
    private static String PARAM_MAJOR_DETAIL_MNY = "P-RjM0C653";

    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO) {
        if (StringUtils.isBlank(contractVO.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUB_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        LambdaQueryWrapper<ContractEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.eq(ContractEntity::getBillCode, contractVO.getBillCode());
        lambda.ne(contractVO.getId() != null && contractVO.getId() > 0, ContractEntity::getId, contractVO.getId());
        List<ContractEntity> entities = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        ContractEntity contractEntity = BeanMapper.map(contractVO, ContractEntity.class);
        contractEntity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        contractEntity.setBeforeChangeMny(contractEntity.getContractMny());
        contractEntity.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        contractEntity.setBaseMoney(contractEntity.getContractMny());
        contractEntity.setBaseTaxMoney(contractEntity.getContractTaxMny());
        boolean b = this.saveOrUpdateNoES(contractEntity);
        List<ContractDetailEntity> contractDetailEntityList = contractEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (ContractDetailEntity cdEntity : contractDetailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ContractDetailEntity cdEntity : contractDetailEntityList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            contractDetailService.saveOrUpdateBatch(contractDetailEntityList);
        }
        if (b) {
            this.countContractNumAndMnyByEnquiry(contractEntity.getEnquiryPriceBillId());
        }
        return queryDetail(contractEntity.getId(), true);
    }

    @Override
    public ContractVO queryDetail(Long id, Boolean detailHasChildren) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO contractVO = BeanMapper.map(contractEntity, ContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<ContractDetailEntity> detailEntityListDb = contractDetailService.queryList(queryParam, false);
        List<ContractDetailEntity> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {


            for (ContractDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<ContractDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, ContractDetailVO.class);
            sortIntMethod(resultMapList);
            if (detailHasChildren) {
                contractVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            } else {
                contractVO.setDetailList(resultMapList);
            }
        } else {
            contractVO.setDetailList(BeanMapper.mapList(detailEntityList, ContractDetailVO.class));
        }
        return contractVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(ContractVO::getId).collect(Collectors.toList());
            //删除后如果是定标新增的则更新定标的签订合同金额
            LambdaQueryWrapper<ContractEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(ContractEntity::getId, ids);
            queryWrapper.isNotNull(ContractEntity::getEnquiryPriceBillId);
            List<ContractEntity> materialContractEntities = this.list(queryWrapper);
            boolean b = this.removeByIds(ids, false);
            if (b && CollectionUtils.isNotEmpty(materialContractEntities)) {
                List<Long> enquiryPriceBillIds = materialContractEntities.stream().filter(t -> t.getEnquiryPriceBillId() != null).map(ContractEntity::getEnquiryPriceBillId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(enquiryPriceBillIds)) {
                    this.countContractNumAndMnyByEnquiry(enquiryPriceBillIds.toArray(new Long[enquiryPriceBillIds.size()]));
                }
            }
        }
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<IPage<ContractVO>> queryListVOs(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage<ContractEntity> page = queryPage(param, false);
        List<ContractVO> contractVOList = BeanMapper.mapList(page.getRecords(), ContractVO.class);
        IPage<ContractVO> contractVOIPage = new Page<>();
        contractVOIPage.setCurrent(page.getCurrent());
        contractVOIPage.setRecords(contractVOList);
        contractVOIPage.setSize(page.getSize());
        contractVOIPage.setTotal(page.getTotal());
        contractVOIPage.setPages(page.getPages());
        return CommonResponse.success("查询成功！", contractVOIPage);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_money) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMoney", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

    @Override
    public ContractVO queryRecordDetail(Long id, boolean b) {
        return null;
    }

    @Override
    public List<ContractDetailVO> refContractDetail(Long contractId, String condition) {
        // 树形根据code和name过滤子项
        String code = null;
        String name = null;
        boolean filterFlag = false;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, String> conditionMap = JSONObject.parseObject(condition, Map.class);
            String codeStr = conditionMap.get("code");
            String nameStr = conditionMap.get("name");
            code = StringUtils.isNotBlank(codeStr) ? codeStr : null;
            name = StringUtils.isNotBlank(nameStr) ? nameStr : null;
            filterFlag = code != null || name != null;
        }
        //根据code和name过滤出来的叶子节点
        HashMap<Long, ContractDetailEntity> leafMap = new HashMap<>();
        QueryWrapper<ContractDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
////        select * from 表名 ORDER BY
//        wrapper.orderBy(true, true, "cast(concat(left(tree_index,INSTR(tree_index,'.')),replace(subString(tree_index,instr(tree_index,'.')+1),'.',''))");
//        wrapper.orderBy(true, true, "cast(concat(left(表名,INSTR(表名,'.')),replace(subString(表名,instr(tree_index,'.')+1),'.',''))");
        List<ContractDetailEntity> detailEntityListDb = contractDetailService.list(wrapper);
        List<ContractDetailEntity> entities = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            for (ContractDetailEntity entity : detailEntityListDb) {
                if (entity.getLeafFlag()) {
                    if (code != null && StringUtils.isNotEmpty(entity.getCode()) && !entity.getCode().contains(code))
                        continue;
                    if (name != null && StringUtils.isNotEmpty(entity.getName()) && !entity.getName().contains(name))
                        continue;
                }
                if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()) {
                    entities.add(entity);
                    if (entity.getLeafFlag()) {
                        leafMap.put(entity.getId(), entity);
                    }
                }
            }
        }
        List<ContractDetailEntity> resList = null;
        //如果带有搜索，递归找叶子节点的父级
        if (filterFlag) {
            resList = handleFilterData(entities, leafMap);
        } else {
            resList = entities;
        }
        List<ContractDetailVO> detailVos = BeanMapper.mapList(resList, ContractDetailVO.class);
        if (CollectionUtils.isNotEmpty(detailVos)) {
            for (ContractDetailVO cdEntity : detailVos) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }
        settleService.getSumSettleNum(detailVos);
        List<ContractDetailVO> contractDetailVOS = TreeNodeBUtil.buildTree(detailVos);
        sortIntMethod(contractDetailVOS);
        return contractDetailVOS;
    }
    private static void sortIntMethod(List<ContractDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                ContractDetailVO o1Detail = objectMapper.convertValue(o1, ContractDetailVO.class);
                ContractDetailVO o2Detail = objectMapper.convertValue(o2, ContractDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                String[] strs2 = o2Detail.getTreeIndex().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }
    private List<ContractDetailEntity> handleFilterData(List<ContractDetailEntity> entities, HashMap<Long, ContractDetailEntity> leafMap) {

        if (MapUtils.isEmpty(leafMap)) {
            entities.clear();
            return entities;
        }
        Map<Long, ContractDetailEntity> map = entities.stream().collect(Collectors.toMap(ContractDetailEntity::getId, Function.identity()));
        ArrayList<ContractDetailEntity> resList = new ArrayList<>();
        for (Long id : leafMap.keySet()) {
            ContractDetailEntity leafContractDetailEntity = leafMap.get(id);
            resList.add(leafContractDetailEntity);
            getContractDetaiParent(leafContractDetailEntity, map, resList);
        }
        return resList;
    }

    private void getContractDetaiParent(ContractDetailEntity leafContractDetailEntity, Map<Long, ContractDetailEntity> map, List<ContractDetailEntity> resList) {
        Long parentId = leafContractDetailEntity.getParentId();
        if(null != parentId){
            resList.add(map.get(parentId));
            getContractDetaiParent(map.get(parentId), map , resList);
        }

    }


    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<ContractDetailVO> detailVoList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ContractDetailVO vo = new ContractDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setTreeIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType + "清单编码为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType = warnType + "清单名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }
                    if(StringUtils.isNotEmpty(datas.get(3)) && datas.get(3).length() > 2000){
                        flag = true;
                        warnType = warnType + "特征描述/规格型号超过2000字,";
                    }
                    vo.setSpec(datas.get(3));
                    vo.setUnit(datas.get(4));//计量单位

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setNum(null);
                        warnType = warnType + "工程量为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "工程量只能为数字或小数,";
                            flag = true;
                        }
                    }

                    // 修改由合价计算综合单价
                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setPrice(null);
                        warnType = warnType + "综合单价为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setPrice(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType + "综合单价只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if(!flag){
                        vo.setMoney(vo.getPrice().multiply(vo.getNum()).setScale(2, BigDecimal.ROUND_HALF_UP));
                    }
//                    if (StringUtils.isEmpty(datas.get(7))) {
//                        vo.setMoney(null);
//                        warnType = warnType + "合价为空,";
//                        flag = true;
//                    } else {
//                        try {
//                            vo.setMoney(new BigDecimal(datas.get(7)));
//                        } catch (Exception e) {
//                            vo.setMoney(null);
//                            warnType = warnType + "合价只能为数字或小数,";
//                            flag = true;
//                        }
//                    }

                   /* if (null == vo.getNum() || null == vo.getMoney()) {
                        vo.setPrice(null);
                    } else {
                        vo.setPrice(BigDecimalUtils.safeDiv(vo.getMoney(), vo.getNum()));
                        //vo.setPrice(vo.getMoney().divide(vo.getNum(), 20 ,BigDecimal.ROUND_HALF_EVEN));
                    }*/

                    if ((null == vo.getPrice() || vo.getPrice().compareTo(BigDecimal.ZERO) == 0) && null != vo.getMoney()) {
                        vo.setPrice(BigDecimalUtils.safeDiv(vo.getMoney(), vo.getNum()).setScale(2, BigDecimal.ROUND_HALF_UP));
                    }

                    if ((null == vo.getMoney() || vo.getMoney().compareTo(BigDecimal.ZERO) == 0) && null != vo.getPrice()) {
                        vo.setMoney(BigDecimalUtils.safeMultiply(vo.getNum(), vo.getPrice()).setScale(2, BigDecimal.ROUND_HALF_UP));
                    }

                    // end

                    vo.setMemo(datas.get(8));

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }

                for (ContractDetailVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public List<Map<String, Object>> payMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.payMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> prePayMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.prePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> finishMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.finishMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.invoicePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoiceContractMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.invoiceContractMnyWarn(sqlParamList);
    }

    @Override
    public List<SubWarnVo> subProjectOutMny(List<Long> tenantIds) {
        return baseMapper.subProjectOutMny(tenantIds);
    }

    @Override
    public List<SubProjectReportVo> getMonthSubMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthSubMny(projectId, lastDay);
    }

    @Override
    public SubProjectReportVo getSubContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
        lambda.eq(ContractEntity::getProjectId, projectId);
        lambda.eq(ContractEntity::getDr, 0);
        lambda.in(ContractEntity::getBillState, billStatus);
        List<ContractEntity> entities = super.list(lambda);
        for (ContractEntity ce : entities) {
            mny = mny.add(ce.getContractTaxMny() == null ? BigDecimal.ZERO : ce.getContractTaxMny());
        }
        BigDecimal settleMny = baseMapper.getSubContract(projectId);
        SubProjectReportVo vo = new SubProjectReportVo();
        vo.setNum(entities.size());
        vo.setMny(mny);
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<SubProjectSettleNumVO> getSubSettleNum(List<Long> projectIds) {
        return baseMapper.getSubSettleNum(projectIds);
    }

    /**
     * 合同/变更金额参数校验
     * @param vo
     * @return
     */
    @Override
    public ParamsCheckVO checkParams(ContractVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert",new ArrayList<>());
        paramsCheckVOMap.put("warn",new ArrayList<>());

        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        Long contractType = vo.getContractType();
        Integer controlType = 0;
        BigDecimal contractTaxMny = vo.getContractTaxMny();//本期合同金额
        List<ContractDetailVO> detailList = vo.getDetailList(); //明细
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        //预算查询参数VO
        BudgetProjectProParamControlVO proParamControlVO = new BudgetProjectProParamControlVO();
        //项目id
        proParamControlVO.setProjectId(vo.getProjectId());
        //劳务分包
        if(contractType.equals(1270328729526124545l)){
            //查询对应项目的劳务分包预算数据
            proParamControlVO.setCostType(CostTypeEnum.LABOR_COST_TYPE.getType());
            //查询预算
            CommonResponse<BudgetProjectProQuantityAndMnyVO> response = budgetProjectProApi.fetchQuantityAndMny(proParamControlVO);
            //如果没查到预算数据就不控制 20221014
            if (response.getData() != null) {
                //预算人工费总金额
                BigDecimal laborTaxMny = response.getData().getLaborTaxMny();
                //预算人工费清单
                Map<Long, BudgetProjectDetailProVO> detailProMap = response.getData().getDetailProMap();

                //【预算人工费总金额】控【劳务分包合同总金额】P-9P63m148
                CommonResponse<List<BillParamVO>> laborMnyParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_MNY, curOrgId);
                if (laborMnyParamByCode.isSuccess() && null != laborMnyParamByCode.getData()) {
                    List<BillParamVO> data = laborMnyParamByCode.getData();
                    if (CollectionUtils.isNotEmpty(data)) {
                        for (BillParamVO datum : data) {
                            if (0 != datum.getControlType()) {
                                BigDecimal roleValue = datum.getRoleValue();
                                BigDecimal _laborTaxMny = ComputeUtil.safeMultiply(laborTaxMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                                //查询累计已生效的合同金额
                                ContractVO contractVO = this.querySumContractTaxMny(vo.getProjectId(), vo.getId(), vo.getContractId(), vo.getContractType());
                                //含本期累计生效合同金额
                                BigDecimal sumContractTaxMny = ComputeUtil.safeAdd(contractTaxMny, contractVO.getContractTaxMny());
                                if (sumContractTaxMny.compareTo(_laborTaxMny) > 0) {
                                    controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                    paramsCheckDsVO.setOrgName(datum.getOrgName());
                                    paramsCheckDsVO.setWarnItem("合同超预算");
                                    paramsCheckDsVO.setWarnName("劳务分包合同总金额大于预算人工费总金额");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该项目劳务分包合同总金额：").append(sumContractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("元，预算人工费总金额*").append(roleValue).append("%:")
                                            .append(_laborTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元。超出金额：")
                                            .append(ComputeUtil.safeSub(sumContractTaxMny, _laborTaxMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    checkDsVOS.add(paramsCheckDsVO);

                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                } else {
                    logger.info(laborMnyParamByCode.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }
                if (CollectionUtils.isNotEmpty(detailList)) {
                    //预算人工费清单量控
                    CommonResponse<List<BillParamVO>> laborDetailNumParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_DETAIL_NUM, curOrgId);
                    if (laborDetailNumParamByCode.isSuccess() && null != laborDetailNumParamByCode.getData()) {
                        List<BillParamVO> data = laborDetailNumParamByCode.getData();
                        if (CollectionUtils.isNotEmpty(data)) {
                            for (BillParamVO datum : data) {
                                if (0 != datum.getControlType()) {
                                    BigDecimal roleValue = datum.getRoleValue();
                                    //根据项目获取已生效的合同清单
                                    Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                    //本期合同清单
                                    List<ContractDetailVO> voDetailList = BeanMapper.mapList(detailList, ContractDetailVO.class);
                                    voDetailList.forEach(detailVo -> {
                                        //判断生效的合同清单包含本期合同清单，则本期合同清单量 = 本期量+生效量
                                        if (detailMap.containsKey(detailVo.getBudgetDetailId())) {
                                            ContractDetailVO contractDetailVO = detailMap.get(detailVo.getBudgetDetailId());
                                            detailVo.setNum(ComputeUtil.safeAdd(detailVo.getNum(), contractDetailVO != null ? contractDetailVO.getNum() : BigDecimal.ZERO));
                                        }
                                    });
                                    for (ContractDetailVO detailVO : voDetailList) {
                                        //合同含本期量
                                        BigDecimal num = detailVO.getNum();
                                        //判断预算人工费清单是否包含生效含本期合同的清单
                                        if (detailProMap.containsKey(detailVO.getBudgetDetailId())) {
                                            BudgetProjectDetailProVO proVO = detailProMap.get(detailVO.getBudgetDetailId());
                                            //合同预算量
                                            BigDecimal proNum = proVO.getNum();
                                            BigDecimal _proNum = ComputeUtil.safeMultiply(proNum, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                                            if (num.compareTo(_proNum) > 0) {
                                                controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                                paramsCheckDsVO.setWarnItem(detailVO.getCode() + "-" + detailVO.getName());
                                                paramsCheckDsVO.setWarnName("劳务分包合同清单量 > 预算人工费清单量");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("分包清单工程量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                        .append("，预算清单工程量*").append(roleValue).append("%:")
                                                        .append(_proNum.setScale(2, BigDecimal.ROUND_HALF_UP)).append("。超出量：")
                                                        .append(ComputeUtil.safeSub(num, _proNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                checkDsVOS.add(paramsCheckDsVO);

                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        logger.info(laborDetailNumParamByCode.getMsg());
                        throw new BusinessException("获取控制参数失败");
                    }

                    //预算人工费清单金额控
                    CommonResponse<List<BillParamVO>> laborDetailMnyParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_DETAIL_MNY, curOrgId);
                    if (laborDetailMnyParamByCode.isSuccess() && null != laborDetailMnyParamByCode.getData()) {
                        List<BillParamVO> data = laborDetailMnyParamByCode.getData();
                        if (CollectionUtils.isNotEmpty(data)) {
                            for (BillParamVO datum : data) {
                                if (0 != datum.getControlType()) {
                                    BigDecimal roleValue = datum.getRoleValue();
                                    //根据项目获取已生效的合同清单
                                    Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                    //本期合同清单
                                    List<ContractDetailVO> voDetailList = BeanMapper.mapList(detailList, ContractDetailVO.class);
                                    voDetailList.forEach(detailVo -> {
                                        //判断生效的合同清单包含本期合同清单，则本期合同清单量 = 本期量+生效量
                                        if (detailMap.containsKey(detailVo.getBudgetDetailId())) {
                                            ContractDetailVO contractDetailVO = detailMap.get(detailVo.getBudgetDetailId());
                                            detailVo.setMoney(ComputeUtil.safeAdd(detailVo.getMoney(), contractDetailVO != null ? contractDetailVO.getMoney() : BigDecimal.ZERO));
                                        }
                                    });
                                    for (ContractDetailVO detailVO : voDetailList) {
                                        //合同含本期金额
                                        BigDecimal money = detailVO.getMoney();
                                        //判断预算人工费清单是否包含生效含本期合同的清单
                                        if (detailProMap.containsKey(detailVO.getBudgetDetailId())) {
                                            BudgetProjectDetailProVO proVO = detailProMap.get(detailVO.getBudgetDetailId());
                                            //合同预算量
                                            BigDecimal proMny = proVO.getTaxMny();
                                            BigDecimal _proMny = ComputeUtil.safeMultiply(proMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                                            if (money.compareTo(_proMny) > 0) {
                                                controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                                paramsCheckDsVO.setWarnItem(detailVO.getCode() + "-" + detailVO.getName());
                                                paramsCheckDsVO.setWarnName("劳务分包合同清单合价 > 预算人工费清单合价");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("分包清单合价：").append(money.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                        .append("，预算清单合价*").append(roleValue).append("%:")
                                                        .append(_proMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("。超出金额：")
                                                        .append(ComputeUtil.safeSub(money, _proMny).setScale(2, BigDecimal.ROUND_HALF_UP));
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                checkDsVOS.add(paramsCheckDsVO);

                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        logger.info(laborDetailMnyParamByCode.getMsg());
                        throw new BusinessException("获取控制参数失败");
                    }
                }
            }
        }
        //专业分包
        if(contractType.equals(1270328674299723778l)){
            //查询对应项目的专业分包预算数据
            proParamControlVO.setCostType(CostTypeEnum.MAJOR_COST_TYPE.getType());
            //查询预算
            CommonResponse<BudgetProjectProQuantityAndMnyVO> response = budgetProjectProApi.fetchQuantityAndMny(proParamControlVO);
            //如果没查到预算数据就不控制 20221014
            if (response.getData() != null) {
                //预算专业分包费总金额
                BigDecimal majorTaxMny = response.getData().getMajorTaxMny();
                //预算专业分包清单
                Map<Long, BudgetProjectDetailProVO> detailProMap = response.getData().getDetailProMap();

                //【预算专业分包总金额】控 【专业分包合同总金额】P-k3cSoQ49
                CommonResponse<List<BillParamVO>> majorMnyParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_MAJOR_MNY, curOrgId);
                if (majorMnyParamByCode.isSuccess() && null != majorMnyParamByCode.getData()) {
                    List<BillParamVO> data = majorMnyParamByCode.getData();
                    if (CollectionUtils.isNotEmpty(data)) {
                        for (BillParamVO datum : data) {
                            if (0 != datum.getControlType()) {
                                BigDecimal roleValue = datum.getRoleValue();
                                BigDecimal _majorTaxMny = ComputeUtil.safeMultiply(majorTaxMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                                //查询累计已生效的合同金额
                                ContractVO contractVO = this.querySumContractTaxMny(vo.getProjectId(), vo.getId(), vo.getContractId(), vo.getContractType());
                                //含本期累计生效合同金额
                                BigDecimal sumContractTaxMny = ComputeUtil.safeAdd(contractTaxMny, contractVO.getContractTaxMny());
                                if (sumContractTaxMny.compareTo(_majorTaxMny) > 0) {
                                    controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                    paramsCheckDsVO.setOrgName(datum.getOrgName());
                                    paramsCheckDsVO.setWarnItem("合同超预算");
                                    paramsCheckDsVO.setWarnName("专业分包合同总金额大于预算专业分包费总金额");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该项目专业分包合同总金额：").append(sumContractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("元，预算专业分包总金额*").append(roleValue).append("%:")
                                            .append(_majorTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元。超出金额：")
                                            .append(ComputeUtil.safeSub(sumContractTaxMny, _majorTaxMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    checkDsVOS.add(paramsCheckDsVO);

                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                } else {
                    logger.info(majorMnyParamByCode.getMsg());
                    throw new BusinessException("获取控制参数失败");
                }
                if (CollectionUtils.isNotEmpty(detailList)) {
                    //预算专业分包清单量控
                    CommonResponse<List<BillParamVO>> majorDetailNumParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_MAJOR_DETAIL_NUM, curOrgId);
                    if (majorDetailNumParamByCode.isSuccess() && null != majorDetailNumParamByCode.getData()) {
                        List<BillParamVO> data = majorDetailNumParamByCode.getData();
                        if (CollectionUtils.isNotEmpty(data)) {
                            for (BillParamVO datum : data) {
                                if (0 != datum.getControlType()) {
                                    BigDecimal roleValue = datum.getRoleValue();
                                    //根据项目获取已生效的合同清单
                                    Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                    //本期合同清单
                                    List<ContractDetailVO> voDetailList = BeanMapper.mapList(detailList, ContractDetailVO.class);
                                    voDetailList.forEach(detailVo -> {
                                        //判断生效的合同清单包含本期合同清单，则本期合同清单量 = 本期量+生效量
                                        if (detailMap.containsKey(detailVo.getBudgetDetailId())) {
                                            ContractDetailVO contractDetailVO = detailMap.get(detailVo.getBudgetDetailId());
                                            detailVo.setNum(ComputeUtil.safeAdd(detailVo.getNum(), contractDetailVO != null ? contractDetailVO.getNum() : BigDecimal.ZERO));
                                        }
                                    });
                                    for (ContractDetailVO detailVO : voDetailList) {
                                        //合同含本期量
                                        BigDecimal num = detailVO.getNum();
                                        //判断预算专业分包费清单是否包含生效含本期合同的清单
                                        if (detailProMap.containsKey(detailVO.getBudgetDetailId())) {
                                            BudgetProjectDetailProVO proVO = detailProMap.get(detailVO.getBudgetDetailId());
                                            //合同预算量
                                            BigDecimal proNum = proVO.getNum();
                                            BigDecimal _proNum = ComputeUtil.safeMultiply(proNum, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                                            if (num.compareTo(_proNum) > 0) {
                                                controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                                paramsCheckDsVO.setWarnItem(detailVO.getCode() + "-" + detailVO.getName());
                                                paramsCheckDsVO.setWarnName("专业分包合同清单量 > 预算专业分包费清单量");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("分包清单工程量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                        .append("，预算清单工程量*").append(roleValue).append("%:")
                                                        .append(_proNum.setScale(2, BigDecimal.ROUND_HALF_UP)).append("。超出量：")
                                                        .append(ComputeUtil.safeSub(num, _proNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                checkDsVOS.add(paramsCheckDsVO);

                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        logger.info(majorDetailNumParamByCode.getMsg());
                        throw new BusinessException("获取控制参数失败");
                    }

                    //预算专业分包清单金额控
                    CommonResponse<List<BillParamVO>> majorDetailMnyParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_MAJOR_DETAIL_MNY, curOrgId);
                    if (majorDetailMnyParamByCode.isSuccess() && null != majorDetailMnyParamByCode.getData()) {
                        List<BillParamVO> data = majorDetailMnyParamByCode.getData();
                        if (CollectionUtils.isNotEmpty(data)) {
                            for (BillParamVO datum : data) {
                                if (0 != datum.getControlType()) {
                                    BigDecimal roleValue = datum.getRoleValue();
                                    //根据项目获取已生效的合同清单
                                    Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                    //本期合同清单
                                    List<ContractDetailVO> voDetailList = BeanMapper.mapList(detailList, ContractDetailVO.class);
                                    voDetailList.forEach(detailVo -> {
                                        //判断生效的合同清单包含本期合同清单，则本期合同清单量 = 本期量+生效量
                                        if (detailMap.containsKey(detailVo.getBudgetDetailId())) {
                                            ContractDetailVO contractDetailVO = detailMap.get(detailVo.getBudgetDetailId());
                                            detailVo.setMoney(ComputeUtil.safeAdd(detailVo.getMoney(), contractDetailVO != null ? contractDetailVO.getMoney() : BigDecimal.ZERO));
                                        }
                                    });
                                    for (ContractDetailVO detailVO : voDetailList) {
                                        //合同含本期量
                                        BigDecimal money = detailVO.getMoney();
                                        //判断预算专业分包费清单是否包含生效含本期合同的清单
                                        if (detailProMap.containsKey(detailVO.getBudgetDetailId())) {
                                            BudgetProjectDetailProVO proVO = detailProMap.get(detailVO.getBudgetDetailId());
                                            //合同预算量
                                            BigDecimal proMny = proVO.getTaxMny();
                                            BigDecimal _proMny = ComputeUtil.safeMultiply(proMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                                            if (money.compareTo(_proMny) > 0) {
                                                controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                                paramsCheckDsVO.setWarnItem(detailVO.getCode() + "-" + detailVO.getName());
                                                paramsCheckDsVO.setWarnName("专业分包合同清单合价 > 预算专业分包费清单合价");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("分包清单合价：").append(money.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                        .append("，预算清单合价*").append(roleValue).append("%:")
                                                        .append(_proMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("。超出金额：")
                                                        .append(ComputeUtil.safeSub(money, _proMny).setScale(2, BigDecimal.ROUND_HALF_UP));
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                checkDsVOS.add(paramsCheckDsVO);

                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        logger.info(majorDetailMnyParamByCode.getMsg());
                        throw new BusinessException("获取控制参数失败");
                    }
                }
            }
        }


        // 施工合同金额控制支出
        CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId);
        if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
            List<BillParamVO> billParamVOS = sghtkzc.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getContractId(), vo.getProjectId(), vo.getContractTaxMny());
                CommonResponse<BigDecimal> res = incomeContractApi.fetchSghtzje(vo.getProjectId());
                if (!res.isSuccess()) {
                    throw new BusinessException("获取施工合同工总金额失败");
                }
                BigDecimal sght = res.getData();
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                        BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                        if (sjzcje.compareTo(sghtzje) > 0) {
                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目实际支出总金额：")
                                    .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，施工合同工总金额*")
                                    .append(roleValue)
                                    .append("%：")
                                    .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，超出金额：")
                                    .append(ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("实际支出总金额超施工合同总金额");
                            paramsCheckDsVO.setWarnName("实际支出总金额大于施工合同总金额");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }


        paramsCheckVO.setWarnType(paramsArray[controlType]);

        //paramsCheckVO.setDataSource(checkDsVOS);
        //处理刚性、柔性预警
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private BigDecimal getSjzcje(Long id, Long contractId, Long projectId, BigDecimal mny) {
        BigDecimal fb = baseMapper.fetchSjzcje(projectId, id, contractId);
        CommonResponse<BigDecimal> wzCommonResponse = materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "物资" + "实际支出金额失败");
        }
        BigDecimal wz = wzCommonResponse.getData();
        CommonResponse<BigDecimal> zzcCommonResponse = rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "周转材" + "实际支出金额失败");
        }
        BigDecimal zzc = zzcCommonResponse.getData();
        CommonResponse<BigDecimal> sbcgCommonResponse = equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备采购" + "实际支出金额失败");
        }
        BigDecimal sbcg = sbcgCommonResponse.getData();
        CommonResponse<BigDecimal> sbzlCommonResponse = equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备租赁" + "实际支出金额失败");
        }
        BigDecimal sbzl = sbzlCommonResponse.getData();
        CommonResponse<BigDecimal> qtCommonResponse = otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "其他" + "实际支出金额失败");
        }
        BigDecimal qt = qtCommonResponse.getData();
        CommonResponse<BigDecimal> fybxCommonResponse = financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "费用报销" + "实际支出金额失败");
        }
        BigDecimal fybx = fybxCommonResponse.getData();
        CommonResponse<BigDecimal> lxCommonResponse = financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "零星" + "实际支出金额失败");
        }
        BigDecimal lx = lxCommonResponse.getData();
        CommonResponse<BigDecimal> yjCommonResponse = financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "备用金" + "实际支出金额失败");
        }
        BigDecimal yj = yjCommonResponse.getData();
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }


    /**
     * 合同/变更明细参数校验   暂时废弃
     *
     * @param vo
     *
     * @return
     */
    @Override
    public ParamsCheckVO checkParamsDetail(ContractVO vo) {
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert",new ArrayList<>());
        paramsCheckVOMap.put("warn",new ArrayList<>());

        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        List<ContractDetailVO> detailList = vo.getDetailList();
        Long contractType = vo.getContractType();
        Integer controlType = 0;
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            //预算查询参数VO
            BudgetProjectProParamControlVO proParamControlVO = new BudgetProjectProParamControlVO();
            //项目id
            proParamControlVO.setProjectId(vo.getProjectId());
            //劳务分包
            if(contractType.equals(1270328729526124545l)){
                //查询对应项目的劳务分包预算数据
                proParamControlVO.setCostType(CostTypeEnum.LABOR_COST_TYPE.getType());
                //查询预算
                CommonResponse<BudgetProjectProQuantityAndMnyVO> response = budgetProjectProApi.fetchQuantityAndMny(proParamControlVO);
                //如果没查到预算数据就不控制 20221014
                if(response.getData()!=null){
                    //预算人工费清单
                    Map<Long, BudgetProjectDetailProVO> detailProMap = response.getData().getDetailProMap();

                    //预算人工费清单量控
                    CommonResponse<List<BillParamVO>> laborDetailNumParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_DETAIL_NUM, vo.getOrgId());
                    if (laborDetailNumParamByCode.isSuccess() && null != laborDetailNumParamByCode.getData()) {
                        List<BillParamVO> data = laborDetailNumParamByCode.getData();
                        if(CollectionUtils.isNotEmpty(data)){
                            for (BillParamVO datum : data) {
                                if (0 != datum.getControlType()) {
                                    BigDecimal roleValue = datum.getRoleValue();
                                    //根据项目获取已生效的合同清单
                                    Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                    //本期合同清单
                                    List<ContractDetailVO> voDetailList = BeanMapper.mapList(detailList,ContractDetailVO.class);
                                    voDetailList.forEach(detailVo->{
                                        //判断生效的合同清单包含本期合同清单，则本期合同清单量 = 本期量+生效量
                                        if(detailMap.containsKey(detailVo.getBudgetDetailId())){
                                            ContractDetailVO contractDetailVO = detailMap.get(detailVo.getBudgetDetailId());
                                            detailVo.setNum(ComputeUtil.safeAdd(detailVo.getNum(),contractDetailVO !=null ? contractDetailVO.getNum() : BigDecimal.ZERO));
                                        }
                                    });
                                    for (ContractDetailVO detailVO : voDetailList) {
                                        //合同含本期量
                                        BigDecimal num = detailVO.getNum();
                                        //判断预算人工费清单是否包含生效含本期合同的清单
                                        if(detailProMap.containsKey(detailVO.getBudgetDetailId())){
                                            BudgetProjectDetailProVO proVO = detailProMap.get(detailVO.getBudgetDetailId());
                                            //合同预算量
                                            BigDecimal proNum = proVO.getNum();
                                            BigDecimal _proNum = ComputeUtil.safeMultiply(proNum,ComputeUtil.safeDiv(roleValue,BigDecimal.valueOf(100)));
                                            if(num.compareTo(_proNum)>0){
                                                controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                                paramsCheckDsVO.setWarnItem(detailVO.getCode()+"-"+detailVO.getName());
                                                paramsCheckDsVO.setWarnName("劳务分包合同清单量 > 预算人工费清单量");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("分包清单工程量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                        .append("，预算清单工程量*").append(roleValue).append("%:")
                                                        .append(_proNum.setScale(2,BigDecimal.ROUND_HALF_UP)).append("。超出量：")
                                                        .append(ComputeUtil.safeSub(num,_proNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                checkDsVOS.add(paramsCheckDsVO);

                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }else{
                        logger.info(laborDetailNumParamByCode.getMsg());
                        throw new BusinessException("获取控制参数失败");
                    }

                    //预算人工费清单金额控
                    CommonResponse<List<BillParamVO>> laborDetailMnyParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_DETAIL_MNY,vo.getOrgId());
                    if (laborDetailMnyParamByCode.isSuccess() && null != laborDetailMnyParamByCode.getData()){
                        List<BillParamVO> data = laborDetailMnyParamByCode.getData();
                        if(CollectionUtils.isNotEmpty(data)){
                            for (BillParamVO datum : data) {
                                if (0 != datum.getControlType()) {
                                    BigDecimal roleValue = datum.getRoleValue();
                                    //根据项目获取已生效的合同清单
                                    Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                    //本期合同清单
                                    List<ContractDetailVO> voDetailList = BeanMapper.mapList(detailList,ContractDetailVO.class);
                                    voDetailList.forEach(detailVo->{
                                        //判断生效的合同清单包含本期合同清单，则本期合同清单量 = 本期量+生效量
                                        if(detailMap.containsKey(detailVo.getBudgetDetailId())){
                                            ContractDetailVO contractDetailVO = detailMap.get(detailVo.getBudgetDetailId());
                                            detailVo.setMoney(ComputeUtil.safeAdd(detailVo.getMoney(),contractDetailVO !=null ? contractDetailVO.getMoney() : BigDecimal.ZERO));
                                        }
                                    });
                                    for (ContractDetailVO detailVO : voDetailList) {
                                        //合同含本期金额
                                        BigDecimal money = detailVO.getMoney();
                                        //判断预算人工费清单是否包含生效含本期合同的清单
                                        if(detailProMap.containsKey(detailVO.getBudgetDetailId())){
                                            BudgetProjectDetailProVO proVO = detailProMap.get(detailVO.getBudgetDetailId());
                                            //合同预算量
                                            BigDecimal proMny = proVO.getTaxMny();
                                            BigDecimal _proMny = ComputeUtil.safeMultiply(proMny,ComputeUtil.safeDiv(roleValue,BigDecimal.valueOf(100)));
                                            if(money.compareTo(_proMny)>0){
                                                controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                                paramsCheckDsVO.setWarnItem(detailVO.getCode()+"-"+detailVO.getName());
                                                paramsCheckDsVO.setWarnName("劳务分包合同清单合价 > 预算人工费清单合价");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("分包清单合价：").append(money.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                        .append("，预算清单合价*").append(roleValue).append("%:")
                                                        .append(_proMny.setScale(2,BigDecimal.ROUND_HALF_UP)).append("。超出金额：")
                                                        .append(ComputeUtil.safeSub(money,_proMny).setScale(2, BigDecimal.ROUND_HALF_UP));
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                checkDsVOS.add(paramsCheckDsVO);

                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }else{
                        logger.info(laborDetailMnyParamByCode.getMsg());
                        throw new BusinessException("获取控制参数失败");
                    }

                }
            }
            //专业分包
            if(contractType.equals(1270328674299723778l)){
                //查询对应项目的专业分包预算数据
                proParamControlVO.setCostType(CostTypeEnum.MAJOR_COST_TYPE.getType());
                //查询预算
                CommonResponse<BudgetProjectProQuantityAndMnyVO> response = budgetProjectProApi.fetchQuantityAndMny(proParamControlVO);
                if(response.getData()!=null){
                    //预算专业分包清单
                    Map<Long, BudgetProjectDetailProVO> detailProMap = response.getData().getDetailProMap();

                    //预算专业分包清单量控
                    CommonResponse<List<BillParamVO>> majorDetailNumParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_MAJOR_DETAIL_NUM,vo.getOrgId());
                    if (majorDetailNumParamByCode.isSuccess() && null != majorDetailNumParamByCode.getData()) {
                        List<BillParamVO> data = majorDetailNumParamByCode.getData();
                        if(CollectionUtils.isNotEmpty(data)){
                            for (BillParamVO datum : data) {
                                if (0 != datum.getControlType()) {
                                    BigDecimal roleValue = datum.getRoleValue();
                                    //根据项目获取已生效的合同清单
                                    Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                    //本期合同清单
                                    List<ContractDetailVO> voDetailList = BeanMapper.mapList(detailList,ContractDetailVO.class);
                                    voDetailList.forEach(detailVo->{
                                        //判断生效的合同清单包含本期合同清单，则本期合同清单量 = 本期量+生效量
                                        if(detailMap.containsKey(detailVo.getBudgetDetailId())){
                                            ContractDetailVO contractDetailVO = detailMap.get(detailVo.getBudgetDetailId());
                                            detailVo.setNum(ComputeUtil.safeAdd(detailVo.getNum(),contractDetailVO !=null ? contractDetailVO.getNum() : BigDecimal.ZERO));
                                        }
                                    });
                                    for (ContractDetailVO detailVO : voDetailList) {
                                        //合同含本期量
                                        BigDecimal num = detailVO.getNum();
                                        //判断预算专业分包费清单是否包含生效含本期合同的清单
                                        if(detailProMap.containsKey(detailVO.getBudgetDetailId())){
                                            BudgetProjectDetailProVO proVO = detailProMap.get(detailVO.getBudgetDetailId());
                                            //合同预算量
                                            BigDecimal proNum = proVO.getNum();
                                            BigDecimal _proNum = ComputeUtil.safeMultiply(proNum,ComputeUtil.safeDiv(roleValue,BigDecimal.valueOf(100)));
                                            if(num.compareTo(_proNum)>0){
                                                controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                                paramsCheckDsVO.setWarnItem(detailVO.getCode()+"-"+detailVO.getName());
                                                paramsCheckDsVO.setWarnName("专业分包合同清单量 > 预算专业分包费清单量");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("分包清单工程量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                        .append("，预算清单工程量*").append(roleValue).append("%:")
                                                        .append(_proNum.setScale(2,BigDecimal.ROUND_HALF_UP)).append("。超出量：")
                                                        .append(ComputeUtil.safeSub(num,_proNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                checkDsVOS.add(paramsCheckDsVO);

                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }else{
                        logger.info(majorDetailNumParamByCode.getMsg());
                        throw new BusinessException("获取控制参数失败");
                    }

                    //预算专业分包清单金额控
                    CommonResponse<List<BillParamVO>> majorDetailMnyParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_MAJOR_DETAIL_MNY,vo.getOrgId());
                    if (majorDetailMnyParamByCode.isSuccess() && null != majorDetailMnyParamByCode.getData()) {
                        List<BillParamVO> data = majorDetailMnyParamByCode.getData();
                        if(CollectionUtils.isNotEmpty(data)){
                            for (BillParamVO datum : data) {
                                if (0 != datum.getControlType()) {
                                    BigDecimal roleValue = datum.getRoleValue();
                                    //根据项目获取已生效的合同清单
                                    Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                    //本期合同清单
                                    List<ContractDetailVO> voDetailList = BeanMapper.mapList(detailList,ContractDetailVO.class);
                                    voDetailList.forEach(detailVo->{
                                        //判断生效的合同清单包含本期合同清单，则本期合同清单量 = 本期量+生效量
                                        if(detailMap.containsKey(detailVo.getBudgetDetailId())){
                                            ContractDetailVO contractDetailVO = detailMap.get(detailVo.getBudgetDetailId());
                                            detailVo.setMoney(ComputeUtil.safeAdd(detailVo.getMoney(),contractDetailVO !=null ? contractDetailVO.getMoney() : BigDecimal.ZERO));
                                        }
                                    });
                                    for (ContractDetailVO detailVO : voDetailList) {
                                        //合同含本期量
                                        BigDecimal money = detailVO.getMoney();
                                        //判断预算专业分包费清单是否包含生效含本期合同的清单
                                        if(detailProMap.containsKey(detailVO.getBudgetDetailId())){
                                            BudgetProjectDetailProVO proVO = detailProMap.get(detailVO.getBudgetDetailId());
                                            //合同预算量
                                            BigDecimal proMny = proVO.getTaxMny();
                                            BigDecimal _proMny = ComputeUtil.safeMultiply(proMny,ComputeUtil.safeDiv(roleValue,BigDecimal.valueOf(100)));
                                            if(money.compareTo(_proMny)>0){
                                                controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;

                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                                paramsCheckDsVO.setWarnItem(detailVO.getCode()+"-"+detailVO.getName());
                                                paramsCheckDsVO.setWarnName("专业分包合同清单合价 > 预算专业分包费清单合价");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                stringBuffer.append("分包清单合价：").append(money.setScale(2, BigDecimal.ROUND_HALF_UP))
                                                        .append("，预算清单合价*").append(roleValue).append("%:")
                                                        .append(_proMny.setScale(2,BigDecimal.ROUND_HALF_UP)).append("。超出金额：")
                                                        .append(ComputeUtil.safeSub(money,_proMny).setScale(2, BigDecimal.ROUND_HALF_UP));
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                checkDsVOS.add(paramsCheckDsVO);

                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }else{
                        logger.info(majorDetailMnyParamByCode.getMsg());
                        throw new BusinessException("获取控制参数失败");
                    }

                }
            }
            paramsCheckVO.setWarnType(paramsArray[controlType]);

            //paramsCheckVO.setDataSource(checkDsVOS);
            //处理刚性、柔性预警
            ParamsCheckVO pc = new ParamsCheckVO();
            if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
                pc.setWarnType("alert");
                pc.setDataSource(paramsCheckVOMap.get("alert"));
            } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
                pc.setWarnType("warn");
                pc.setDataSource(paramsCheckVOMap.get("warn"));
            } else {
                pc.setWarnType("none");
                pc.setDataSource(null);
            }
            return pc;
        }
        return paramsCheckVO;
    }

    /**
     * 根据项目id,分包类型查询累计生效的合同金额
     * @param projectId
     * @param id
     * @param contractType
     */
    public ContractVO querySumContractTaxMny(Long projectId,Long id,Long contractId,Long contractType){
        //查询非变更中已生效的单据总金额---------------------------------
        ContractEntity one = new ContractEntity();
        QueryWrapper<ContractEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id",projectId);
        wrapper.eq("contract_type",contractType);
        wrapper.eq("dr",0);
        if(id!=null){
            wrapper.ne("id",id);
        }
        if(contractId!=null){
            wrapper.ne("id",contractId);
        }
        wrapper.ne("change_status",2);
        //wrapper.in("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        //按项目id，分包类型查询对应的已生效合同总金额
        List<ContractEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            BigDecimal contractTaxMny = list.stream().map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            one.setContractTaxMny(contractTaxMny);
        }
        //查询变更审批中的----------------------------------------------
        QueryWrapper<ChangeEntity> cWrapper = new QueryWrapper<>();
        cWrapper.select(" IFNULL(sum(contract_tax_mny),0) AS contractTaxMny");
        cWrapper.eq("project_id",projectId);
        cWrapper.eq("contract_type",contractType);
        cWrapper.eq("dr",0);
        if(id!=null){
            cWrapper.ne("id",id);
        }
        cWrapper.in("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
                BillStateEnum.SUSPEND.getBillStateCode());
        ChangeEntity one1 = changeService.getOne(cWrapper);
        one.setContractTaxMny(ComputeUtil.safeAdd(one.getContractTaxMny(),one1.getContractTaxMny()));
        ContractVO vo = new ContractVO();
        if(one!=null){
            vo = BeanMapper.map(one,ContractVO.class);
        }
        return vo;
    }

    /**
     * 根据项目查询已生效的合同清单
     * @param vo
     */
    public Map<Long,ContractDetailVO> queryContractDetailMap(ContractVO vo){
        Map<Long,ContractDetailVO> resMap= new HashMap<>();
        Map<String,Object > map = new HashMap<>();
        map.put("projectId",vo.getProjectId());
        map.put("contractType",vo.getContractType());
        map.put("dr",0);
        if(vo.getId()!=null){
            map.put("id",vo.getId());
        }
        if(vo.getContractId()!=null){
            map.put("contractId",vo.getContractId());
        }
        List<ContractDetailVO> voList = baseMapper.queryContractDetailList(map);
        if(CollectionUtils.isNotEmpty(voList)){
            resMap = voList.stream().collect(Collectors.toMap(ContractDetailVO::getBudgetDetailId,contractDetailVO -> contractDetailVO));
        }
        return resMap;
    }

    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }


    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null, null);
    }

    /**
     * @return {@link PicketageVO}
     *
     * @description: 根据定标单回写已签合同数量和金额
     * @author songlx
     * @date: 2023/11/8
     */
    @Override
    public PicketageVO countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds) {
        if(enquiryPriceBillIds != null && enquiryPriceBillIds.length > 0){
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper<ContractEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.select("count(1) as num, IFNULL(sum(contract_tax_mny),0) as money")
                        .eq("enquiry_price_bill_id", enquiryPriceBillId);
                Map<String, Object> map = this.getMap(queryWrapper);
                PicketageVO picketageVO = new PicketageVO();
                if(MapUtils.isNotEmpty(map)){
                    Integer num = map.get("num") != null ?  Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                    picketageVO.setId(enquiryPriceBillId);
                    picketageVO.setContractSign(num);
                    picketageVO.setContractSignMny(money);
                } else {
                    picketageVO.setId(enquiryPriceBillId);
                    picketageVO.setContractSign(0);
                    picketageVO.setContractSignMny(BigDecimal.ZERO);
                }
                picketageApi.updateContractSignMny(picketageVO);
            }
        }
        return null;
    }
}
