/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.sub.bean.LabSettleEntity;
import com.ejianc.business.sub.mapper.LabSettleMapper;
import com.ejianc.business.sub.service.ILabSettleService;
import com.ejianc.business.sub.vo.LabSettleVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="labSettleService")
public class LabSettleServiceImpl
extends BaseServiceImpl<LabSettleMapper, LabSettleEntity>
implements ILabSettleService {
    @Autowired
    private IPayContractApi payContractApi;

    @Override
    public JSONObject querySubSettleVOList(QueryParam param, boolean isEs) {
        QueryWrapper wrapper;
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<LabSettleVO> list = ((LabSettleMapper)this.baseMapper).querySubSettleVOList(pages, wrapper = LabSettleServiceImpl.changeToQueryWrapper((QueryParam)param));
        if (CollectionUtils.isNotEmpty(list)) {
            List settleIds = list.stream().map(e -> e.getId()).collect(Collectors.toList());
            CommonResponse applyMnyHasFreeRes = this.payContractApi.getApplyMnyHasFree(settleIds);
            Map settleApplyData = (Map)applyMnyHasFreeRes.getData();
            for (LabSettleVO subSettleVO : list) {
                BigDecimal sumApplyMnyHasFree = (BigDecimal)settleApplyData.get(subSettleVO.getId());
                subSettleVO.setSumApplyMny(sumApplyMnyHasFree);
                BigDecimal surplusApplyMny = ComputeUtil.safeSub((BigDecimal)subSettleVO.getSettleTaxMny(), (BigDecimal)sumApplyMnyHasFree);
                subSettleVO.setSurplusApplyMny(surplusApplyMny);
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }
}

