package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.LabSettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ILabSettleService;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;

@Service("labSettle") 
public class LabSettleBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private ILabSettleService service;

	@Autowired
	private IContractService contractService;

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		LabSettleEntity labSettleEntity = service.selectById(billId);
		ContractEntity contractEntity  = contractService.getById(labSettleEntity.getContractId());
		BigDecimal settleTaxMny = labSettleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : labSettleEntity.getSettleTaxMny();
		BigDecimal settleMny = labSettleEntity.getSettleMny() == null ? BigDecimal.ZERO : labSettleEntity.getSettleMny();
		LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(ContractEntity::getSumSettleTaxMny, settleTaxMny);
		updateWrapper.set(ContractEntity::getSumSettleMny, settleMny);
		contractService.update(contractEntity, updateWrapper, false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		LabSettleEntity labSettleEntity = service.selectById(billId);
		ContractEntity contractEntity  = contractService.getById(labSettleEntity.getContractId());
		LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(ContractEntity::getSumSettleTaxMny, 0);
		updateWrapper.set(ContractEntity::getSumSettleMny, 0);
		contractService.update(contractEntity, updateWrapper, false);
		return CommonResponse.success();
	}

}
