/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contract")
public class ContractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private PSRMRestUtil psrmRestUtil;

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(billId));
        if (res.isSuccess()) {
            Long conorgid = contractEntity.getOrgId();
            CommonResponse conResp = this.orgApi.getOneById(conorgid);
            if (!conResp.isSuccess() || !conResp.isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Long currentOrg = InvocationInfoProxy.getOrgId();
            String innerCode = ((OrgVO)conResp.getData()).getInnerCode();
            if ("2".equals(contractEntity.getPurchaseType()) && !innerCode.contains(String.valueOf(currentOrg))) {
                return CommonResponse.error((String)("\u5f53\u524d\u96c6\u91c7\u5408\u540c\u7f16\u5236\u7ec4\u7ec7\u662f\u3010" + contractEntity.getOrgName() + "\u3011\uff0c\u4e0d\u53ef\u64a4\u56de\uff01"));
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractVO vo = (ContractVO)BeanMapper.map((Object)this.contractService.selectById(billId), ContractVO.class);
        if (this.psrmRestUtil.isRunMode().booleanValue() && vo.getProjectId() != null) {
            PSRMResponse resp = this.contractService.saveOrUpdatePsrmObj(vo);
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(ContractEntity::getPsrmCode, (Object)resp.getPsrmCode());
            updateWrapper.set(ContractEntity::getPsrmReturncode, (Object)resp.getReturncode());
            updateWrapper.set(ContractEntity::getPsrmReturndata, (Object)JSONObject.toJSONString((Object)resp));
            this.contractService.update((Wrapper)updateWrapper);
            if (!resp.isSuccess()) {
                return CommonResponse.error((String)("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25" + JSONObject.toJSONString((Object)resp)));
            }
        }
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(billId));
        if (this.psrmRestUtil.isRunMode().booleanValue() && StringUtils.isNotBlank((CharSequence)contractEntity.getPsrmReturncode())) {
            PSRMResponse resp = this.psrmRestUtil.disableOrDelObj(contractEntity.getPsrmCode(), "dmp.purchaseorder.del");
            this.logger.info("{} psrmResponse:{}", (Object)this.getClass().getName(), (Object)resp);
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(ContractEntity::getPsrmReturncode, (Object)resp.getReturncode());
            updateWrapper.set(resp.isSuccess(), ContractEntity::getPsrmCode, null);
            updateWrapper.set(ContractEntity::getPsrmReturndata, (Object)JSONObject.toJSONString((Object)resp));
            this.contractService.update((Wrapper)updateWrapper);
            if (!resp.isSuccess()) {
                return CommonResponse.error((String)("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)resp)));
            }
        }
        return CommonResponse.success();
    }
}

