package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleReportService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.ITreeNodeB;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.*;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 分包汇总表 服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("SettleReportServiceImpl")
public class SettleReportServiceImpl implements ISettleReportService {

    @Autowired
    private IContractService contractService;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IPayContractApi payContractApi;

    @Override
    public CommonResponse<SettleReportVO> queryReport(Long contractId, Long settleId, Integer showSum, Integer showThis, Boolean detailHasChildren) {
        if(null == contractId){
            throw new BusinessException("合同主键为空");
        }
        return CommonResponse.success(fullData(contractId, settleId, showSum, showThis, detailHasChildren));
    }

    private SettleReportVO fullData(Long contractId, Long settleId, Integer showSum, Integer showThis, Boolean detailHasChildren){
        PubContractSubQueryVO queryVO = new PubContractSubQueryVO();
        SettleReportVO settleReportVO = null;
        SettleVO settleVO = null;
        if(null == settleId){
            LambdaQueryWrapper<SettleEntity> settleWrapper = new LambdaQueryWrapper<>();
            settleWrapper.eq(SettleEntity::getContractId, contractId);
            settleWrapper.in(SettleEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            settleWrapper.orderByDesc(SettleEntity::getSettleDate);
            List<SettleEntity> settleEntities = settleService.list(settleWrapper);
            if (CollectionUtils.isNotEmpty(settleEntities)){
                settleVO = settleService.queryDetail(settleEntities.get(0).getId(), false);
            }else{
                throw new BusinessException("该合同没有无对应过程结算");
            }
        }else{
            settleVO = settleService.queryDetail(settleId, false);
        }

        queryVO.setContractId(settleVO.getContractId());
        queryVO.setProjectId(settleVO.getProjectId());
        queryVO.setSettleId(settleVO.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        queryVO.setSettleDate(sdf.format(settleVO.getSettleDate()) + " 23:59:59");

        settleReportVO = BeanMapper.map(settleVO, SettleReportVO.class);

        ContractVO contractVO =  contractService.queryDetail(contractId, false);
        //1.选了结算，结算合同数据合并，作为基础维度数据
        //2.没选结算，先取最后一次审批通过结算，然后结算合同数据合并，作为基础维度数据
        Map<Long, SettleReportDetailVO> reportDetailVOMap = changeToReportVO(settleReportVO, contractVO, settleVO);
        //处理所选结算之前结算
        settleReportVO.setPayMny(settleReportVO.getPayMny()==null?BigDecimal.ZERO:settleReportVO.getPayMny());
        settleReportVO.setSumPayMny(settleReportVO.getSumPayMny()==null?BigDecimal.ZERO:settleReportVO.getSumPayMny());
        dealBeforeSettle(queryVO, settleReportVO, reportDetailVOMap, settleVO);

        dealShowSettle(settleReportVO, showSum, showThis, detailHasChildren);

        return settleReportVO;
    }

    private Map<Long, SettleReportDetailVO> changeToReportVO(SettleReportVO settleReportVO, ContractVO contractVO, SettleVO settleVO) {
        Map<Long, SettleReportDetailVO> reportDetailVOMap = new LinkedHashMap<>();
        settleReportVO.setSettleId(settleVO.getId());
        settleReportVO.setBillCode(settleVO.getBillCode());
        settleReportVO.setSumSettleTaxMny(settleReportVO.getSettleTaxMny().add(settleReportVO.getSumSettleTaxMny()));

        settleReportVO.setSettleDetailList(null);
        settleReportVO.setSettleOddjobList(null);
        settleReportVO.setSettleOtherList(null);

        if (CollectionUtils.isNotEmpty(contractVO.getDetailList())) {
            for(ContractDetailVO contractDetailVO : contractVO.getDetailList()){
                SettleReportDetailVO reportDetailVO = BeanMapper.map(contractDetailVO, SettleReportDetailVO.class);
                reportDetailVO.setContractDetailId(contractDetailVO.getId());
                reportDetailVO.setSourceType(1);
                reportDetailVOMap.put(contractDetailVO.getId(), reportDetailVO);
            }
        }

        if (CollectionUtils.isNotEmpty(settleVO.getSettleDetailList())) {
            for(SettleDetailVO settleDetailVO : settleVO.getSettleDetailList()){
                if(1 == settleDetailVO.getSourceType() && reportDetailVOMap.containsKey(settleDetailVO.getContractDetailId())){
                    SettleReportDetailVO settleReportDetailVO = reportDetailVOMap.get(settleDetailVO.getContractDetailId());
                    settleReportDetailVO.setSettleNum(settleDetailVO.getSettleNum());
                    settleReportDetailVO.setSettleMny(settleDetailVO.getSettleMny());
                    settleReportDetailVO.setSettlePrice(settleReportDetailVO.getPrice());
                    settleReportDetailVO.setSumSettleNum(MathUtil.safeAdd(settleReportDetailVO.getSumSettleNum(), settleDetailVO.getSettleNum()));
                    settleReportDetailVO.setSumSettleMny(MathUtil.safeAdd(settleReportDetailVO.getSumSettleMny(), settleDetailVO.getSettleMny()));
                    settleReportDetailVO.setSourceType(settleDetailVO.getSourceType());
                }else{
                    SettleReportDetailVO settleReportDetailVO = BeanMapper.map(settleDetailVO, SettleReportDetailVO.class);
                    settleReportDetailVO.setSettlePrice(settleReportDetailVO.getPrice());
                    settleReportDetailVO.setSumSettleNum(MathUtil.safeAdd(settleReportDetailVO.getSumSettleNum(), settleDetailVO.getSettleNum()));
                    settleReportDetailVO.setSumSettleMny(MathUtil.safeAdd(settleReportDetailVO.getSumSettleMny(), settleDetailVO.getSettleMny()));
                    reportDetailVOMap.put(settleDetailVO.getId(), settleReportDetailVO);
                }
            }
        }

        List<SettleReportOddjobVO> oddjobVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(settleVO.getSettleOddjobList())){
            for(SettleOddjobVO oddjobVO : settleVO.getSettleOddjobList()){
                SettleReportOddjobVO reportOddjobVO = BeanMapper.map(oddjobVO, SettleReportOddjobVO.class);
                reportOddjobVO.setSettleBillCode(settleVO.getBillCode());
                reportOddjobVO.setSettleDate(settleVO.getSettleDate());
                oddjobVOList.add(reportOddjobVO);
            }
        }

        List<SettleReportOtherVO> otherVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(settleVO.getSettleOtherList())){
            for(SettleOtherVO otherVO : settleVO.getSettleOtherList()){
                SettleReportOtherVO reportOtherVO = BeanMapper.map(otherVO, SettleReportOtherVO.class);
                reportOtherVO.setSettleBillCode(settleVO.getBillCode());
                reportOtherVO.setSettleDate(settleVO.getSettleDate());
                otherVOList.add(reportOtherVO);
            }
        }

        settleReportVO.setSettleDetailList(reportDetailVOMap.entrySet().stream().map(et->et.getValue()).collect(Collectors.toList()));
        settleReportVO.setSettleOddjobList(oddjobVOList);
        settleReportVO.setSettleOtherList(otherVOList);

        return reportDetailVOMap;
    }

    private void dealBeforeSettle(PubContractSubQueryVO queryVO, SettleReportVO settleReportVO, Map<Long, SettleReportDetailVO> reportDetailVOMap, SettleVO settleVO) {
        LambdaQueryWrapper<SettleEntity> settleWrapper = new LambdaQueryWrapper<>();
        settleWrapper.eq(SettleEntity::getContractId, settleVO.getContractId());
        settleWrapper.ne(SettleEntity::getId, settleVO.getId());
        settleWrapper.in(SettleEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        settleWrapper.between(SettleEntity::getSettleDate, "1990-12-31 00:00:00", settleVO.getSettleDate());
        List<SettleEntity> settleEntities = settleService.list(settleWrapper);
        if(CollectionUtils.isNotEmpty(settleEntities)){
            List<Long> settlePkList = new ArrayList<>();
            settlePkList.add(settleVO.getId());
            for(SettleEntity settleEntity : settleEntities){

                settlePkList.add(settleEntity.getId());

                SettleVO beforeSettleVO = settleService.queryDetail(settleEntity.getId(), false);
                if (CollectionUtils.isNotEmpty(beforeSettleVO.getSettleDetailList())) {
                    for(SettleDetailVO settleDetailVO : beforeSettleVO.getSettleDetailList()){
                        if(1 == settleDetailVO.getSourceType() && reportDetailVOMap.containsKey(settleDetailVO.getContractDetailId())){
                            SettleReportDetailVO settleReportDetailVO = reportDetailVOMap.get(settleDetailVO.getContractDetailId());
                            settleReportDetailVO.setSourceType(settleDetailVO.getSourceType());
                            settleReportDetailVO.setSumSettleNum(MathUtil.safeAdd(settleReportDetailVO.getSumSettleNum(), settleDetailVO.getSettleNum()));
                            settleReportDetailVO.setSumSettleMny(MathUtil.safeAdd(settleReportDetailVO.getSumSettleMny(), settleDetailVO.getSettleMny()));
                        }else{
                            SettleReportDetailVO settleReportDetailVO = BeanMapper.map(settleDetailVO, SettleReportDetailVO.class);
                            settleReportDetailVO.setSettleNum(null);
                            settleReportDetailVO.setSettleMny(null);
                            settleReportDetailVO.setSumSettleNum(MathUtil.safeAdd(settleReportDetailVO.getSumSettleNum(), settleDetailVO.getSettleNum()));
                            settleReportDetailVO.setSumSettleMny(MathUtil.safeAdd(settleReportDetailVO.getSumSettleMny(), settleDetailVO.getSettleMny()));
                            reportDetailVOMap.put(settleDetailVO.getId(), settleReportDetailVO);
                        }
                    }
                }

                List<SettleReportOddjobVO> oddjobVOList = settleReportVO.getSettleOddjobList();
                if(CollectionUtils.isNotEmpty(beforeSettleVO.getSettleOddjobList())){
                    for(SettleOddjobVO oddjobVO : beforeSettleVO.getSettleOddjobList()){
                        SettleReportOddjobVO reportOddjobVO = BeanMapper.map(oddjobVO, SettleReportOddjobVO.class);
                        reportOddjobVO.setSettleBillCode(beforeSettleVO.getBillCode());
                        reportOddjobVO.setSettleDate(beforeSettleVO.getSettleDate());
                        oddjobVOList.add(reportOddjobVO);
                    }
                }

                Collections.sort(oddjobVOList, new Comparator<SettleReportOddjobVO>() {
                        @Override
                        public int compare(SettleReportOddjobVO u1, SettleReportOddjobVO u2) {
                             if (u1.getSettleDate().compareTo(u2.getSettleDate())  < 0) {
                                  return 1;
                             }else if (u1.getSettleDate().compareTo(u2.getSettleDate()) > 0) {
                                 return -1;
                             }
                              return 0; //相等为0
                         }
                });
                settleReportVO.setSettleOddjobList(oddjobVOList);

                List<SettleReportOtherVO> otherVOList = settleReportVO.getSettleOtherList();
                if(CollectionUtils.isNotEmpty(beforeSettleVO.getSettleOtherList())){
                    for(SettleOtherVO otherVO : beforeSettleVO.getSettleOtherList()){
                        SettleReportOtherVO reportOtherVO = BeanMapper.map(otherVO, SettleReportOtherVO.class);
                        reportOtherVO.setSettleBillCode(beforeSettleVO.getBillCode());
                        reportOtherVO.setSettleDate(beforeSettleVO.getSettleDate());
                        otherVOList.add(reportOtherVO);
                    }
                }
                Collections.sort(otherVOList, new Comparator<SettleReportOtherVO>() {
                    @Override
                    public int compare(SettleReportOtherVO u1, SettleReportOtherVO u2) {
                        if (u1.getSettleDate().compareTo(u2.getSettleDate())  < 0) {
                            return 1;
                        }else if (u1.getSettleDate().compareTo(u2.getSettleDate()) > 0) {
                            return -1;
                        }
                        return 0; //相等为0
                    }
                });
                settleReportVO.setSettleOtherList(otherVOList);

                settleReportVO.setSettleDetailList(reportDetailVOMap.entrySet().stream().map(et->et.getValue()).collect(Collectors.toList()));
            }

            queryVO.setSettleIdList(settlePkList);
            CommonResponse<Map<String, BigDecimal>> payResponse = payContractApi.getSubSettlePay(queryVO);
            if(payResponse.isSuccess()){
                settleReportVO.setPayMny(payResponse.getData().get("thisMny") == null?BigDecimal.ZERO:payResponse.getData().get("thisMny"));
                settleReportVO.setSumPayMny(payResponse.getData().get("sumMny") == null?BigDecimal.ZERO:payResponse.getData().get("sumMny"));
            }else{
                settleReportVO.setPayMny(BigDecimal.ZERO);
                settleReportVO.setSumPayMny(BigDecimal.ZERO);
            }
        }
    }

    private void dealShowSettle(SettleReportVO settleReportVO, Integer showSum, Integer showThis, Boolean detailHasChildren) {
        List<SettleReportDetailVO> detailVOList = settleReportVO.getSettleDetailList();
        List<SettleReportDetailVO> detailVOListCopy = new ArrayList<>();
        Map<String, SettleReportDetailVO> map = new LinkedHashMap<>();
        if(CollectionUtils.isNotEmpty(detailVOList)){
            for(SettleReportDetailVO detailVO : detailVOList){
                if(0 == showSum && 0 == showThis){
                    detailVOListCopy.add(detailVO);
                    map.put(detailVO.getTid(), detailVO);
                }else if(0 == showSum && 1 == showThis){
                    if(null != detailVO.getSettleMny() && BigDecimal.ZERO.compareTo(detailVO.getSettleMny()) != 0){
                        detailVOListCopy.add(detailVO);
                        map.put(detailVO.getTid(), detailVO);
                    }
                }else if(1 == showSum && 0 == showThis){
                    if(null != detailVO.getSumSettleMny() && BigDecimal.ZERO.compareTo(detailVO.getSumSettleMny()) != 0){
                        detailVOListCopy.add(detailVO);
                        map.put(detailVO.getTid(), detailVO);
                    }
                }else if(1 == showSum && 1 == showThis){
                    if((null != detailVO.getSumSettleMny() && BigDecimal.ZERO.compareTo(detailVO.getSumSettleMny()) != 0)
                       && (null != detailVO.getSettleMny() && BigDecimal.ZERO.compareTo(detailVO.getSettleMny()) != 0)){
                        detailVOListCopy.add(detailVO);
                        map.put(detailVO.getTid(), detailVO);
                    }
                }
            }
        }

        for(SettleReportDetailVO detailVO : detailVOListCopy){
            sumNumToParent(map, detailVO);
        }

        List<SettleReportDetailVO> detailVOS = map.entrySet().stream().map(et->et.getValue()).collect(Collectors.toList());

        if(detailHasChildren){
            settleReportVO.setSettleDetailList(TreeNodeBUtil.buildTree(detailVOS));
        }else {
            settleReportVO.setSettleDetailList(detailVOS);
        }
    }

    private void sumNumToParent(Map<String, SettleReportDetailVO> map, SettleReportDetailVO detailVO){
        if (StringUtils.isNotBlank(detailVO.getTpid()) && map.containsKey(detailVO.getTpid())) {
            SettleReportDetailVO parentVO = map.get(detailVO.getTpid());
            parentVO.setSumSettleNum(MathUtil.safeAdd(parentVO.getSumSettleNum(), detailVO.getSumSettleNum()));
            sumNumToParent(map, parentVO);
        }
    }
}
