package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 分包完工结算成本分摊表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_finish_cost")
public class FinishCostEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 完工结算ID
     */
    @TableField("finish_id")
    private Long finishId;

    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 金额
     */
    @TableField("money")
    private BigDecimal money;

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public Long getFinishId() {
        return finishId;
    }

    public void setFinishId(Long finishId) {
        this.finishId = finishId;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
