package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.LabSettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 分包合同审批流服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("contract")
public class ContractBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IContractService contractService;

    @Autowired
    private PSRMRestUtil psrmRestUtil;

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        ContractEntity contractEntity = contractService.selectById(billId);
        if(res.isSuccess()) {//单据未被下游单据引用
            //上级的集采合同不允许被撤回
            Long conorgid = contractEntity.getOrgId();//合同组织主键
            CommonResponse<OrgVO> conResp =  orgApi.getOneById(conorgid);
            if(!conResp.isSuccess() || !conResp.isSuccess()) {
                return CommonResponse.error("查询合同组织信息失败！");
            }
            Long currentOrg = InvocationInfoProxy.getOrgId();
            String innerCode = conResp.getData().getInnerCode();
            if("2".equals(contractEntity.getPurchaseType())&&!innerCode.contains(String.valueOf(currentOrg))){
                //说明-A组织innerCode包含了B主键，说明B是A的上级
                return CommonResponse.error("当前集采合同编制组织是【"+contractEntity.getOrgName()+"】，不可撤回！");
            }

            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractVO vo = BeanMapper.map(contractService.selectById(billId), ContractVO.class);
        if (psrmRestUtil.isRunMode() && vo.getProjectId() != null) {
            PSRMResponse resp = contractService.saveOrUpdatePsrmObj(vo);
            LambdaUpdateWrapper<ContractEntity> updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(ContractEntity::getId, billId);
            updateWrapper.set(ContractEntity::getPsrmCode, resp.getPsrmCode());
            updateWrapper.set(ContractEntity::getPsrmReturncode, resp.getReturncode());
            updateWrapper.set(ContractEntity::getPsrmReturndata, JSONObject.toJSONString(resp));
            contractService.update(updateWrapper);
            if (!resp.isSuccess()) {
                return CommonResponse.error("数据中台操作失败" + JSONObject.toJSONString(resp));
            }
        }

        return CommonResponse.success("回调处理成功！");
    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity contractEntity = contractService.selectById(billId);
        if (psrmRestUtil.isRunMode() && StringUtils.isNotBlank(contractEntity.getPsrmCode())) {
            PSRMResponse resp = psrmRestUtil.disableOrDelObj(contractEntity.getPsrmCode(), "dmp.purchaseorder.del");
            logger.info("{} psrmResponse:{}", this.getClass().getName(), resp);
            LambdaUpdateWrapper<ContractEntity> updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(ContractEntity::getId, billId);
            updateWrapper.set(ContractEntity::getPsrmReturncode, resp.getReturncode());
            updateWrapper.set(resp.isSuccess(), ContractEntity::getPsrmCode, null);
            updateWrapper.set(ContractEntity::getPsrmReturndata, JSONObject.toJSONString(resp));
            contractService.update(updateWrapper);
            if (!resp.isSuccess()) {
                return CommonResponse.error("数据中台操作失败：" + JSONObject.toJSONString(resp));
            }
        }
        return CommonResponse.success();
    }
}
