/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.material.api.IMaterialPickRegisterApi;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.SettlePickDeductVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settle")
public class SettleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IOddjobService oddjobService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMaterialPickRegisterApi materialPickRegisterApi;
    @Autowired
    private ICostDetailApi costDetailApi;

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BigDecimal sumOffsetMnys;
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        SettleEntity settlementEntity = (SettleEntity)((Object)this.settleService.selectById(billId));
        BigDecimal offsetMny = settlementEntity.getOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getOffsetMny();
        BigDecimal sumPayMnys = settlementEntity.getSumPrepayMny() == null ? BigDecimal.ZERO : settlementEntity.getSumPrepayMny();
        BigDecimal bigDecimal = sumOffsetMnys = settlementEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getSumOffsetMny();
        if (offsetMny.compareTo(sumPayMnys.subtract(sumOffsetMnys)) > 0) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u51b2\u62b5\u91d1\u989d\u5df2\u8d85\u51fa\u9884\u4ed8\u6b3e\u91d1\u989d!");
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List updatePickRegisterList;
        List settlePickDeductList;
        SettleVO settleEntity = this.settleService.queryDetail(billId, true);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(settleEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = settleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : settleEntity.getSettleTaxMny();
        BigDecimal settleMny = settleEntity.getSettleMny() == null ? BigDecimal.ZERO : settleEntity.getSettleMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = settleEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobTaxMny();
        BigDecimal jobMny = settleEntity.getOddjobMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = settleEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOtherTaxMny();
        BigDecimal otherMny = settleEntity.getOtherMny() == null ? BigDecimal.ZERO : settleEntity.getOtherMny();
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : contractEntity.getSumOffsetMny();
        BigDecimal offsetMny = settleEntity.getOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getOffsetMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.add(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, (Object)sumSettleMny.add(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.add(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.add(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.add(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, (Object)sumOtherMny.add(otherMny));
        updateWrapper.set(ContractEntity::getSumOffsetMny, (Object)sumOffsetMny.add(offsetMny));
        updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        if (CollectionUtils.isNotEmpty((Collection)settleEntity.getSettleOddjobList())) {
            this.oddjobService.updateSettleMnyByPks(settleEntity.getSettleOddjobList(), Boolean.TRUE);
        }
        if (CollectionUtils.isNotEmpty((Collection)(settlePickDeductList = settleEntity.getSettlePickDeductList())) && CollectionUtils.isNotEmpty(updatePickRegisterList = settlePickDeductList.stream().filter(s -> s.getRegisterId() != null).collect(Collectors.toList()))) {
            ArrayList<PickRegisterDetailVO> pickRegisterDetaiList = new ArrayList<PickRegisterDetailVO>();
            for (SettlePickDeductVO settlePickDeductVO : updatePickRegisterList) {
                PickRegisterDetailVO pickRegisterDetailVO = new PickRegisterDetailVO();
                pickRegisterDetailVO.setId(settlePickDeductVO.getRegisterDetailId());
                pickRegisterDetailVO.setRegisterId(settlePickDeductVO.getRegisterId());
                pickRegisterDetailVO.setDeductMny(settlePickDeductVO.getDeductMny());
                pickRegisterDetaiList.add(pickRegisterDetailVO);
            }
            this.logger.info("\u5165\u53c2\uff1a" + JSONObject.toJSONString(pickRegisterDetaiList));
            if (CollectionUtils.isNotEmpty(pickRegisterDetaiList)) {
                CommonResponse commonResponse = this.materialPickRegisterApi.updateDeductMny(pickRegisterDetaiList);
                this.logger.info("\u8fd4\u56de\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)commonResponse.isSuccess()));
            }
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse commonResponse = this.costDetailApi.checkShareFlag(billId);
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)commonResponse.getMsg());
        }
        SettleEntity settlementEntity = (SettleEntity)((Object)this.settleService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(settlementEntity.getContractId()));
        if (contractEntity.getFinishFlag().booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5b8c\u5de5\u7ed3\u7b97\uff0c\u4e0d\u80fd\u56de\u9000!");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(SettleEntity::getContractId, (Object)settlementEntity.getContractId());
            lambdachange.eq(SettleEntity::getOrgId, (Object)settlementEntity.getOrgId());
            lambdachange.gt(BaseEntity::getCreateTime, (Object)settlementEntity.getCreateTime());
            lambdachange.ne(BaseEntity::getId, (Object)billId);
            lambdachange.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            int num = this.settleService.count((Wrapper)lambdachange);
            if (num > 0) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u4e0d\u662f\u6700\u65b0\u7684\u7ed3\u7b97\u65e5\u671f\uff0c\u4e0d\u80fd\u56de\u9000!");
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        List updatePickRegisterList;
        List settlePickDeductList;
        SettleVO settleEntity = this.settleService.queryDetail(billId, true);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(settleEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = settleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : settleEntity.getSettleTaxMny();
        BigDecimal settleMny = settleEntity.getSettleMny() == null ? BigDecimal.ZERO : settleEntity.getSettleMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = settleEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobTaxMny();
        BigDecimal jobMny = settleEntity.getOddjobMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = settleEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOtherTaxMny();
        BigDecimal otherMny = settleEntity.getOtherMny() == null ? BigDecimal.ZERO : settleEntity.getOtherMny();
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : contractEntity.getSumOffsetMny();
        BigDecimal offsetMny = settleEntity.getOffsetMny() == null ? BigDecimal.ZERO : settleEntity.getOffsetMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.subtract(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, (Object)sumSettleMny.subtract(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.subtract(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.subtract(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.subtract(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, (Object)sumOtherMny.subtract(otherMny));
        updateWrapper.set(ContractEntity::getSumOffsetMny, (Object)sumOffsetMny.subtract(offsetMny));
        updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
        if (CollectionUtils.isNotEmpty((Collection)settleEntity.getSettleOddjobList())) {
            this.oddjobService.updateSettleMnyByPks(settleEntity.getSettleOddjobList(), Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty((Collection)(settlePickDeductList = settleEntity.getSettlePickDeductList())) && CollectionUtils.isNotEmpty(updatePickRegisterList = settlePickDeductList.stream().filter(s -> s.getRegisterId() != null).collect(Collectors.toList()))) {
            ArrayList<PickRegisterDetailVO> pickRegisterDetaiList = new ArrayList<PickRegisterDetailVO>();
            for (SettlePickDeductVO settlePickDeductVO : updatePickRegisterList) {
                PickRegisterDetailVO pickRegisterDetailVO = new PickRegisterDetailVO();
                pickRegisterDetailVO.setId(settlePickDeductVO.getRegisterDetailId());
                pickRegisterDetailVO.setRegisterId(settlePickDeductVO.getRegisterId());
                pickRegisterDetailVO.setDeductMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)settlePickDeductVO.getDeductMny()));
                pickRegisterDetaiList.add(pickRegisterDetailVO);
            }
            this.logger.info("\u5165\u53c2\uff1a" + JSONObject.toJSONString(pickRegisterDetaiList));
            if (CollectionUtils.isNotEmpty(pickRegisterDetaiList)) {
                CommonResponse commonResponse = this.materialPickRegisterApi.updateDeductMny(pickRegisterDetaiList);
                this.logger.info("\u8fd4\u56de\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)commonResponse.isSuccess()));
            }
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }
}

