package com.ejianc.business.sub.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;


@RestController
@RequestMapping(value = "/api/oddjob")
public class OddjobApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IOddjobService service;

	@PostMapping(value = "updateOddjobUse")
	public CommonResponse<String> updateOddjobUse(@RequestBody List<OddjobVO> vos, @RequestParam("isUse") Boolean isUse) {
		for(OddjobVO vo : vos){
			LambdaUpdateWrapper<OddjobEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.set(OddjobEntity::getIsUse, isUse);
			updateWrapper.eq(OddjobEntity::getId, vo.getId());
			OddjobEntity oddjobEntity = service.getById(vo.getId());
			service.update(oddjobEntity, updateWrapper, false);
		}
		return CommonResponse.success("修改无合同零星用工单占用成功！","");
	}
}
