/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.mapper.ContractMapper;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.ExcelImportUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.ContractDetailVO;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SqlParam;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private static final String SUB_CONTRACT_BILL_CODE = "SUB_CONTRACT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ISettleService settleService;

    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO) {
        if (StringUtils.isEmpty((CharSequence)contractVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SUB_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ContractEntity contractEntity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setBeforeChangeMny(contractEntity.getContractMny());
        contractEntity.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        contractEntity.setBaseMoney(contractEntity.getContractMny());
        contractEntity.setBaseTaxMoney(contractEntity.getContractTaxMny());
        super.saveOrUpdate((Object)contractEntity, false);
        List<ContractDetailEntity> contractDetailEntityList = contractEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : contractDetailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ContractDetailEntity cdEntity : contractDetailEntityList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.contractDetailService.saveOrUpdateBatch(contractDetailEntityList, contractDetailEntityList.size(), false);
        }
        return this.queryDetail(contractEntity.getId(), true);
    }

    @Override
    public ContractVO queryDetail(Long id, Boolean detailHasChildren) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO contractVO = (ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.contractDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (ContractDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, ContractDetailVO.class);
            if (detailHasChildren.booleanValue()) {
                contractVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                contractVO.setDetailList(resultMapList);
            }
        } else {
            contractVO.setDetailList(BeanMapper.mapList(detailEntityList, ContractDetailVO.class));
        }
        return contractVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<IPage<ContractVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage page = this.queryPage(param, false);
        List contractVOList = BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class);
        Page contractVOIPage = new Page();
        contractVOIPage.setCurrent(page.getCurrent());
        contractVOIPage.setRecords(contractVOList);
        contractVOIPage.setSize(page.getSize());
        contractVOIPage.setTotal(page.getTotal());
        contractVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)contractVOIPage);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_money) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMoney", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public ContractVO queryRecordDetail(Long id, boolean b) {
        return null;
    }

    @Override
    public List<ContractDetailVO> refContractDetail(Long contractId, String condition) {
        String code = null;
        String name = null;
        boolean filterFlag = false;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            String codeStr = (String)conditionMap.get("code");
            String nameStr = (String)conditionMap.get("name");
            code = StringUtils.isNotBlank((CharSequence)codeStr) ? codeStr : null;
            name = StringUtils.isNotBlank((CharSequence)nameStr) ? nameStr : null;
            filterFlag = code != null || name != null;
        }
        HashMap<Long, ContractDetailEntity> leafMap = new HashMap<Long, ContractDetailEntity>();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.orderBy(true, true, (Object[])new String[]{"tree_index"});
        List detailEntityListDb = this.contractDetailService.list((Wrapper)wrapper);
        ArrayList<ContractDetailEntity> entities = new ArrayList<ContractDetailEntity>();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            for (ContractDetailEntity entity : detailEntityListDb) {
                if (entity.getLeafFlag().booleanValue() && (code != null && StringUtils.isNotEmpty((CharSequence)entity.getCode()) && !entity.getCode().contains(code) || name != null && StringUtils.isNotEmpty((CharSequence)entity.getName()) && !entity.getName().contains(name)) || null != entity.getChangeType() && ChangeTypeEnum.\u4e2d\u6b62.getCode() == entity.getChangeType()) continue;
                entities.add(entity);
                if (!entity.getLeafFlag().booleanValue()) continue;
                leafMap.put(entity.getId(), entity);
            }
        }
        List<ContractDetailEntity> resList = null;
        resList = filterFlag ? this.handleFilterData(entities, leafMap) : entities;
        List detailVos = BeanMapper.mapList(resList, ContractDetailVO.class);
        if (CollectionUtils.isNotEmpty((Collection)detailVos)) {
            for (ContractDetailVO cdEntity : detailVos) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        this.settleService.getSumSettleNum(detailVos);
        return TreeNodeBUtil.buildTree((List)detailVos);
    }

    private List<ContractDetailEntity> handleFilterData(List<ContractDetailEntity> entities, HashMap<Long, ContractDetailEntity> leafMap) {
        if (MapUtils.isEmpty(leafMap)) {
            entities.clear();
            return entities;
        }
        Map<Long, ContractDetailEntity> map = entities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        ArrayList<ContractDetailEntity> resList = new ArrayList<ContractDetailEntity>();
        for (Long id : leafMap.keySet()) {
            ContractDetailEntity leafContractDetailEntity = leafMap.get(id);
            resList.add(leafContractDetailEntity);
            this.getContractDetaiParent(leafContractDetailEntity, map, resList);
        }
        return resList;
    }

    private void getContractDetaiParent(ContractDetailEntity leafContractDetailEntity, Map<Long, ContractDetailEntity> map, List<ContractDetailEntity> resList) {
        Long parentId = leafContractDetailEntity.getParentId();
        if (null != parentId) {
            resList.add(map.get(parentId));
            this.getContractDetaiParent(map.get(parentId), map, resList);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<ContractDetailVO> detailVoList = new ArrayList<ContractDetailVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ContractDetailVO vo = new ContractDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setTreeIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u6e05\u5355\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                vo.setUnit((String)datas.get(3));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setNum(null);
                    warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setPrice(null);
                    warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setPrice(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setMoney(null);
                    warnType = warnType + "\u5408\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setMoney(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        vo.setMoney(null);
                        warnType = warnType + "\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if ((null == vo.getPrice() || vo.getPrice().compareTo(BigDecimal.ZERO) == 0) && null != vo.getMoney()) {
                    vo.setPrice(BigDecimalUtils.safeDiv(vo.getMoney(), vo.getNum()));
                }
                if ((null == vo.getMoney() || vo.getMoney().compareTo(BigDecimal.ZERO) == 0) && null != vo.getPrice()) {
                    vo.setMoney(BigDecimalUtils.safeMultiply(vo.getNum(), vo.getPrice()));
                }
                vo.setMemo((String)datas.get(7));
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(Integer.valueOf(3));
                detailVoList.add(vo);
            }
            for (ContractDetailVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public List<Map<String, Object>> payMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).payMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> prePayMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).prePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> finishMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).finishMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).invoicePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoiceContractMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).invoiceContractMnyWarn(sqlParamList);
    }

    @Override
    public List<SubWarnVo> subProjectOutMny(List<Long> tenantIds) {
        return ((ContractMapper)this.baseMapper).subProjectOutMny(tenantIds);
    }

    @Override
    public List<SubProjectReportVo> getMonthSubMny(Long projectId, Integer lastDay) {
        return ((ContractMapper)this.baseMapper).getMonthSubMny(projectId, lastDay);
    }

    @Override
    public SubProjectReportVo getSubContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(ContractEntity::getBillState, billStatus);
        List entities = super.list((Wrapper)lambda);
        for (ContractEntity ce : entities) {
            mny = mny.add(ce.getContractTaxMny() == null ? BigDecimal.ZERO : ce.getContractTaxMny());
        }
        BigDecimal settleMny = ((ContractMapper)this.baseMapper).getSubContract(projectId);
        SubProjectReportVo vo = new SubProjectReportVo();
        vo.setNum(Integer.valueOf(entities.size()));
        vo.setMny(mny);
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<SubProjectSettleNumVO> getSubSettleNum(List<Long> projectIds) {
        return ((ContractMapper)this.baseMapper).getSubSettleNum(projectIds);
    }
}

