package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 分包合同表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_contract")
public class ContractEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同编码
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 分包类型
     */
    @TableField("contract_type")
    private Long contractType;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField("contract_status")
    private String contractStatus;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 总包企业ID
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 总包企业名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 分包企业ID
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 分包企业名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 签约日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 初始版本金额（含税）
     */
    @TableField("base_tax_money")
    private BigDecimal baseTaxMoney;

    /**
     * 初始版本金额
     */
    @TableField("base_money")
    private BigDecimal baseMoney;

    /**
     * 变更前金额（含税）
     */
    @TableField("before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更前金额
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 变更中金额（含税）
     */
    @TableField("changing_tax_mny")
    private BigDecimal changingTaxMny;

    /**
     * 变更中金额
     */
    @TableField("changing_mny")
    private BigDecimal changingMny;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    @TableField("pay_scale")
    private BigDecimal payScale;

    /**
     * 是否项目  1-自采，2-集采
     */
    @TableField("purchase_type")
    private String purchaseType;

    /**
     * 分包内容
     */
    @TableField("memo")
    private String memo;

    /**
     * 是否竣工(1:是，0：否)
     */
    @TableField("finish_flag")
    private Boolean finishFlag;

    /**
     * 变更单号
     */
    @TableField("change_code")
    private String changeCode;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    @TableField("change_status")
    private Integer changeStatus;

    /**
     * 累计结算金额（含税）
     */
    @TableField("sum_settle_tax_mny")
    private BigDecimal sumSettleTaxMny;

    /**
     * 累计结算金额
     */
    @TableField("sum_settle_mny")
    private BigDecimal sumSettleMny;

    /**
     * 累计零工金额（含税）
     */
    @TableField("sum_oddjob_tax_mny")
    private BigDecimal sumOddjobTaxMny;

    /**
     * 累计零工金额
     */
    @TableField("sum_oddjob_mny")
    private BigDecimal sumOddjobMny;

    /**
     * 累计零工结算金额（含税）
     */
    @TableField("sum_oddjob_settle_tax_mny")
    private BigDecimal sumOddjobSettleTaxMny;

    /**
     * 累计零工结算金额
     */
    @TableField("sum_oddjob_settle_mny")
    private BigDecimal sumOddjobSettleMny;

    /**
     * 累计其他结算金额（含税）
     */
    @TableField("sum_other_tax_mny")
    private BigDecimal sumOtherTaxMny;

    /**
     * 累计其他结算金额
     */
    @TableField("sum_other_mny")
    private BigDecimal sumOtherMny;

    /**
     * 累计收票金额(不含税)
     */
    @TableField("sum_invoice_mny")
    private BigDecimal sumInvoiceMny;

    /**
     * 累计收票金额
     */
    @TableField("sum_invoice_tax_mny")
    private BigDecimal sumInvoiceTaxMny;

    /**
     * 累计预付款金额
     */
    @TableField("sum_prepay_mny")
    private BigDecimal sumPrepayMny;

    /**
     * 累计付款金额
     */
    @TableField("sum_pay_mny")
    private BigDecimal sumPayMny;

    /**
     * 累计冲抵金额
     */
    @TableField("sum_offset_mny")
    private BigDecimal sumOffsetMny;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 合同明细集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="ContractDetailServiceImpl",pidName = "contractId")
    private List<ContractDetailEntity> detailList;

    /**
     * 合同条款集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="ContractClauseServiceImpl",pidName = "contractId")
    private List<ContractClauseEntity> clauseList;

    @TableField(exist=false)
    @SubEntity(serviceName="contractStageService",pidName = "contractId")
    private List<ContractStageEntity> stageList; // 分包合同阶段实体

    @TableField("purchase_type_name")
    private String purchaseTypeName;


    @TableField("invoice_type")
    private Long invoiceType; // 发票类型

    @TableField("invoice_type_name")
    private String invoiceTypeName;


    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Boolean getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(Boolean finishFlag) {
        this.finishFlag = finishFlag;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    public BigDecimal getSumOddjobTaxMny() {
        return sumOddjobTaxMny;
    }

    public void setSumOddjobTaxMny(BigDecimal sumOddjobTaxMny) {
        this.sumOddjobTaxMny = sumOddjobTaxMny;
    }
    public BigDecimal getSumOddjobMny() {
        return sumOddjobMny;
    }

    public void setSumOddjobMny(BigDecimal sumOddjobMny) {
        this.sumOddjobMny = sumOddjobMny;
    }
    public BigDecimal getSumOtherTaxMny() {
        return sumOtherTaxMny;
    }

    public void setSumOtherTaxMny(BigDecimal sumOtherTaxMny) {
        this.sumOtherTaxMny = sumOtherTaxMny;
    }
    public BigDecimal getSumOtherMny() {
        return sumOtherMny;
    }

    public void setSumOtherMny(BigDecimal sumOtherMny) {
        this.sumOtherMny = sumOtherMny;
    }
    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }
    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }
    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }
    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<ContractDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<ContractClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public BigDecimal getSumOddjobSettleTaxMny() {
        return sumOddjobSettleTaxMny;
    }

    public void setSumOddjobSettleTaxMny(BigDecimal sumOddjobSettleTaxMny) {
        this.sumOddjobSettleTaxMny = sumOddjobSettleTaxMny;
    }

    public BigDecimal getSumOddjobSettleMny() {
        return sumOddjobSettleMny;
    }

    public void setSumOddjobSettleMny(BigDecimal sumOddjobSettleMny) {
        this.sumOddjobSettleMny = sumOddjobSettleMny;
    }

    public List<ContractStageEntity> getStageList() {
        return stageList;
    }

    public void setStageList(List<ContractStageEntity> stageList) {
        this.stageList = stageList;
    }
}
