package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 分包完工结算表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_finish")
public class FinishEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 结算单号
     */
    @TableField("bill_code")
    private String  billCode;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 分包供应商
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 分包供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 结算日期
     */
    @TableField("settle_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate;

    /**
     * 分包类型
     */
    @TableField("contract_type")
    private Long contractType;

    /**
     * 分包合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 分包合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 完工结算金额(不含税)
     */
    @TableField("settle_mny")
    private BigDecimal settleMny;

    /**
     * 完工结算金额(含税)
     */
    @TableField("settle_tax_mny")
    private BigDecimal settleTaxMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 累计结算金额(不含税)
     */
    @TableField("sum_settle_mny")
    private BigDecimal sumSettleMny;

    /**
     * 累计结算金额
     */
    @TableField("sum_settle_tax_mny")
    private BigDecimal sumSettleTaxMny;

    /**
     * 累计零工结算金额（含税）
     */
    @TableField("sum_oddjob_settle_tax_mny")
    private BigDecimal sumOddjobSettleTaxMny;

    /**
     * 累计零工结算金额
     */
    @TableField("sum_oddjob_settle_mny")
    private BigDecimal sumOddjobSettleMny;

    /**
     * 本次零工结算金额（含税）
     */
    @TableField("oddjob_tax_mny")
    private BigDecimal oddjobTaxMny;

    /**
     * 本次零工结算金额
     */
    @TableField("oddjob_mny")
    private BigDecimal oddjobMny;

    /**
     * 累计其他结算金额（含税）
     */
    @TableField("sum_other_tax_mny")
    private BigDecimal sumOtherTaxMny;

    /**
     * 累计其他结算金额
     */
    @TableField("sum_other_mny")
    private BigDecimal sumOtherMny;

    /**
     * 本次其他结算金额（含税）
     */
    @TableField("other_tax_mny")
    private BigDecimal otherTaxMny;

    /**
     * 本次其他结算金额
     */
    @TableField("other_mny")
    private BigDecimal otherMny;

    /**
     * 完工结算应付金额（含税）
     */
    @TableField("should_pay_tax_mny")
    private BigDecimal shouldPayTaxMny;

    /**
     * 完工结算应付金额
     */
    @TableField("should_pay_mny")
    private BigDecimal shouldPayMny;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 完工结算明细集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="FinishDetailServiceImpl",pidName = "finishId")
    private List<FinishDetailEntity> finishDetailList;

    /**
     * 完工结算零工集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="FinishOddjobServiceImpl",pidName = "finishId")
    private List<FinishOddjobEntity> finishOddjobList;

    /**
     * 完工结算其他集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="FinishOtherServiceImpl",pidName = "finishId")
    private List<FinishOtherEntity> finishOtherList;

    /**
     * 完工结算其他集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="finishPickDeductService",pidName = "finishId")
    private List<FinishPickDeductEntity> finishPickDeductList;
    /**
     * 完工结算成本分摊集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="FinishCostServiceImpl",pidName = "finishId")
    private List<FinishCostEntity> finishCostList;

    /**
     * 累计已申请金额
     */
    @TableField("sum_apply_mny")
    private BigDecimal sumApplyMny;

    /**
     * 剩余可申请金额
     */
    @TableField("surplus_apply_mny")
    private BigDecimal surplusApplyMny;

    /**
     * 完工结算比例
     */
    @TableField("settle_scale")
    private BigDecimal settleScale;

    /**
     * 关联状态(1:是，0：否)
     */
    @TableField("relation_flag")
    private String relationFlag;
    /**
     * 分摊状态(1:是，0：否)
     */
    @TableField("proportion_flag")
    private String proportionFlag;

    /**
     * 备注
     */
    private String memo;

    /**
     * 推送凭证标识
     */
    @TableField("voucher_flag")
    private Integer voucherFlag;

    /**
     * 凭证信息json
     */
    @TableField("voucher_info")
    private String voucherInfo;


    public Integer getVoucherFlag() {
        return voucherFlag;
    }

    public void setVoucherFlag(Integer voucherFlag) {
        this.voucherFlag = voucherFlag;
    }

    public String getVoucherInfo() {
        return voucherInfo;
    }

    public void setVoucherInfo(String voucherInfo) {
        this.voucherInfo = voucherInfo;
    }


    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public BigDecimal getSettleScale() {
        return settleScale;
    }

    public void setSettleScale(BigDecimal settleScale) {
        this.settleScale = settleScale;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public BigDecimal getSurplusApplyMny() {
        return surplusApplyMny;
    }

    public void setSurplusApplyMny(BigDecimal surplusApplyMny) {
        this.surplusApplyMny = surplusApplyMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    public BigDecimal getSumOddjobSettleTaxMny() {
        return sumOddjobSettleTaxMny;
    }

    public void setSumOddjobSettleTaxMny(BigDecimal sumOddjobSettleTaxMny) {
        this.sumOddjobSettleTaxMny = sumOddjobSettleTaxMny;
    }
    public BigDecimal getSumOddjobSettleMny() {
        return sumOddjobSettleMny;
    }

    public void setSumOddjobSettleMny(BigDecimal sumOddjobSettleMny) {
        this.sumOddjobSettleMny = sumOddjobSettleMny;
    }
    public BigDecimal getSumOtherTaxMny() {
        return sumOtherTaxMny;
    }

    public void setSumOtherTaxMny(BigDecimal sumOtherTaxMny) {
        this.sumOtherTaxMny = sumOtherTaxMny;
    }
    public BigDecimal getSumOtherMny() {
        return sumOtherMny;
    }

    public void setSumOtherMny(BigDecimal sumOtherMny) {
        this.sumOtherMny = sumOtherMny;
    }

    public BigDecimal getOddjobTaxMny() {
        return oddjobTaxMny;
    }

    public void setOddjobTaxMny(BigDecimal oddjobTaxMny) {
        this.oddjobTaxMny = oddjobTaxMny;
    }

    public BigDecimal getOddjobMny() {
        return oddjobMny;
    }

    public void setOddjobMny(BigDecimal oddjobMny) {
        this.oddjobMny = oddjobMny;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getShouldPayTaxMny() {
        return shouldPayTaxMny;
    }

    public void setShouldPayTaxMny(BigDecimal shouldPayTaxMny) {
        this.shouldPayTaxMny = shouldPayTaxMny;
    }

    public BigDecimal getShouldPayMny() {
        return shouldPayMny;
    }

    public void setShouldPayMny(BigDecimal shouldPayMny) {
        this.shouldPayMny = shouldPayMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<FinishDetailEntity> getFinishDetailList() {
        return finishDetailList;
    }

    public void setFinishDetailList(List<FinishDetailEntity> finishDetailList) {
        this.finishDetailList = finishDetailList;
    }

    public List<FinishOddjobEntity> getFinishOddjobList() {
        return finishOddjobList;
    }

    public void setFinishOddjobList(List<FinishOddjobEntity> finishOddjobList) {
        this.finishOddjobList = finishOddjobList;
    }

    public List<FinishOtherEntity> getFinishOtherList() {
        return finishOtherList;
    }

    public void setFinishOtherList(List<FinishOtherEntity> finishOtherList) {
        this.finishOtherList = finishOtherList;
    }

    public List<FinishPickDeductEntity> getFinishPickDeductList() {
        return finishPickDeductList;
    }

    public void setFinishPickDeductList(List<FinishPickDeductEntity> finishPickDeductList) {
        this.finishPickDeductList = finishPickDeductList;
    }

    public List<FinishCostEntity> getFinishCostList() {
        return finishCostList;
    }

    public void setFinishCostList(List<FinishCostEntity> finishCostList) {
        this.finishCostList = finishCostList;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
