package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 过程结算明细表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_settle_detail")
public class SettleDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 结算ID
     */
    @TableField("settle_id")
    private Long settleId;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同明细ID
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 序号
     */
    @TableField("tree_index")
    private String treeIndex;

    /**
     * 清单编码
     */
    @TableField("code")
    private String code;

    /**
     * 清单名称
     */
    @TableField("name")
    private String name;

    /**
     * 计量单位
     */
    @TableField("unit")
    private String unit;

    /**
     * 工程量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 综合单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 本期结算工程量
     */
    @TableField("settle_num")
    private BigDecimal settleNum;

    /**
     * 本期结算金额
     */
    @TableField("settle_mny")
    private BigDecimal settleMny;

    /**
     * 来源类型(1:合同内，2:合同外)
     */
    @TableField("source_type")
    private Integer sourceType;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 父ID
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 是否末级
     */
    @TableField("leaf_flag")
    private Boolean leafFlag;

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;

    @TableField(value="sum_settle_num")
    private java.math.BigDecimal sumSettleNum; // 累计结算工程量 (不含本期)

    @TableField(value="sum_settle_num_endthis")
    private java.math.BigDecimal sumSettleNumEndthis; // 累计结算工程量 (含本期)

    public BigDecimal getSumSettleNum() {
        return sumSettleNum;
    }

    public void setSumSettleNum(BigDecimal sumSettleNum) {
        this.sumSettleNum = sumSettleNum;
    }

    public BigDecimal getSumSettleNumEndthis() {
        return sumSettleNumEndthis;
    }

    public void setSumSettleNumEndthis(BigDecimal sumSettleNumEndthis) {
        this.sumSettleNumEndthis = sumSettleNumEndthis;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getSettleNum() {
        return settleNum;
    }

    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
}
