package com.ejianc.business.sub.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.vo.FinishRecordVO;
import com.ejianc.business.sub.vo.FinishVO;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 分包完工结算表 前端控制器
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@RestController
@RequestMapping("finish")
public class FinishController implements Serializable {

    @Autowired
    private IFinishService finishService;

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @param finishVO
     * @Return com.ejianc.framework.core.response.CommonResponse<FinishVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinishVO> saveOrUpdate(@RequestBody FinishVO finishVO) {
        FinishVO vo = finishService.insertOrUpdate(finishVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询变更记录详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<FinishVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinishVO> queryDetail(Long id) {
        FinishVO vo = finishService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FinishVO>> queryList(@RequestBody QueryParam param) {
        return finishService.queryListVOs(param);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinishVO> vos) {
        return   finishService.deleteByIds(vos);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryDetailRecord 查询记录
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<FinishRecordVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinishRecordVO> queryDetailRecord(Long id) {
        FinishRecordVO vo = finishService.queryDetailRecord(id);
        return CommonResponse.success("查询记录数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryDetailAdd 新增查询合同转化为完工结算
     * @param contractId
     * @Return com.ejianc.framework.core.response.CommonResponse<FinishVO>
     */
    @RequestMapping(value = "/queryDetailAdd", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinishVO> queryDetailAdd(Long contractId) {
        FinishVO vo = finishService.queryDetailAdd(contractId);
        return CommonResponse.success("新增查询合同转化为完工结算成功！",vo);
    }

    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<FinishVO> list = finishService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("sub-finish-export.xlsx", beans, response);
    }

    /**
     * @Author zhangwx
     * @Date 2020/12/24
     * @Description pushCost关联保存
     * @param finishVO
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinishVO> pushCost(@RequestBody FinishVO finishVO) {
        return finishService.pushCost(finishVO);
    }

    /*
     *
     * @description:
     * @author: 曹鹏辉
     * @date: 2021/5/20 17:52
     * @param: purchaseType
     * @param: settleTaxMny
     * @param: contractTaxMny
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.ParamsCheckVO>
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType
            , @RequestParam(value = "settleTaxMny") BigDecimal settleTaxMny
            , @RequestParam(value = "contractTaxMny") BigDecimal contractTaxMny) {

        return CommonResponse.success("参数校验成功！", finishService.checkParams(purchaseType, settleTaxMny, contractTaxMny));
    }


    /**
     * @description: 推送凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse}
     * @author songlx
     * @date: 2024/1/12
     */
    @RequestMapping(value = "/pushVoucher", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull(billId, "单据billId不能为空！");
        FinishEntity entity = finishService.selectById(billId);
        return finishService.handleVoucher(entity, VoucherOptFlag.RE_PUSH);
    }

}
